/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.ttf.gsub;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fontbox.ttf.CmapLookup;
import org.apache.fontbox.ttf.gsub.GlyphArraySplitterRegexImpl;
import org.apache.fontbox.ttf.gsub.GsubWorker;
import org.apache.fontbox.ttf.model.GsubData;
import org.apache.fontbox.ttf.model.ScriptFeature;

public class GsubWorkerForLatin
implements GsubWorker {
    private static final Log LOG = LogFactory.getLog(GsubWorkerForLatin.class);
    private static final List<String> FEATURES_IN_ORDER = Arrays.asList("ccmp", "liga", "clig");
    private final CmapLookup cmapLookup;
    private final GsubData gsubData;

    GsubWorkerForLatin(CmapLookup cmapLookup, GsubData gsubData) {
        this.cmapLookup = cmapLookup;
        this.gsubData = gsubData;
    }

    @Override
    public List<Integer> applyTransforms(List<Integer> originalGlyphIds) {
        List<Integer> intermediateGlyphsFromGsub = originalGlyphIds;
        for (String feature : FEATURES_IN_ORDER) {
            if (!this.gsubData.isFeatureSupported(feature)) {
                LOG.debug((Object)("the feature " + feature + " was not found"));
                continue;
            }
            LOG.debug((Object)("applying the feature " + feature));
            ScriptFeature scriptFeature = this.gsubData.getFeature(feature);
            intermediateGlyphsFromGsub = this.applyGsubFeature(scriptFeature, intermediateGlyphsFromGsub);
        }
        return Collections.unmodifiableList(intermediateGlyphsFromGsub);
    }

    private List<Integer> applyGsubFeature(ScriptFeature scriptFeature, List<Integer> originalGlyphs) {
        if (scriptFeature.getAllGlyphIdsForSubstitution().isEmpty()) {
            LOG.debug((Object)("getAllGlyphIdsForSubstitution() for " + scriptFeature.getName() + " is empty"));
            return originalGlyphs;
        }
        GlyphArraySplitterRegexImpl glyphArraySplitter = new GlyphArraySplitterRegexImpl(scriptFeature.getAllGlyphIdsForSubstitution());
        List<List<Integer>> tokens = glyphArraySplitter.split(originalGlyphs);
        ArrayList<Integer> gsubProcessedGlyphs = new ArrayList<Integer>();
        for (List<Integer> chunk : tokens) {
            if (scriptFeature.canReplaceGlyphs(chunk)) {
                int glyphId = scriptFeature.getReplacementForGlyphs(chunk);
                gsubProcessedGlyphs.add(glyphId);
                continue;
            }
            gsubProcessedGlyphs.addAll(chunk);
        }
        LOG.debug((Object)("originalGlyphs: " + originalGlyphs + ", gsubProcessedGlyphs: " + gsubProcessedGlyphs));
        return gsubProcessedGlyphs;
    }
}

