/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.exec;

import ghidra.pcode.exec.PcodeArithmetic;
import ghidra.pcode.opbehavior.BinaryOpBehavior;
import ghidra.pcode.opbehavior.OpBehaviorFactory;
import ghidra.pcode.opbehavior.UnaryOpBehavior;
import ghidra.pcode.utils.Utils;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Endian;
import ghidra.program.model.lang.Language;
import java.math.BigInteger;

public enum BytesPcodeArithmetic implements PcodeArithmetic<byte[]>
{
    BIG_ENDIAN(Endian.BIG),
    LITTLE_ENDIAN(Endian.LITTLE);

    private final Endian endian;

    public static BytesPcodeArithmetic forEndian(boolean bigEndian) {
        return bigEndian ? BIG_ENDIAN : LITTLE_ENDIAN;
    }

    public static BytesPcodeArithmetic forLanguage(Language language) {
        return BytesPcodeArithmetic.forEndian(language.isBigEndian());
    }

    private BytesPcodeArithmetic(Endian endian) {
        this.endian = endian;
    }

    @Override
    public Endian getEndian() {
        return this.endian;
    }

    @Override
    public byte[] unaryOp(int opcode, int sizeout, int sizein1, byte[] in1) {
        UnaryOpBehavior b = (UnaryOpBehavior)OpBehaviorFactory.getOpBehavior(opcode);
        boolean isBigEndian = this.endian.isBigEndian();
        if (sizein1 > 8 || sizeout > 8) {
            BigInteger in1Val = Utils.bytesToBigInteger((byte[])in1, (int)sizein1, (boolean)isBigEndian, (boolean)false);
            BigInteger outVal = b.evaluateUnary(sizeout, sizein1, in1Val);
            return Utils.bigIntegerToBytes((BigInteger)outVal, (int)sizeout, (boolean)isBigEndian);
        }
        long in1Val = Utils.bytesToLong((byte[])in1, (int)sizein1, (boolean)isBigEndian);
        long outVal = b.evaluateUnary(sizeout, sizein1, in1Val);
        return Utils.longToBytes((long)outVal, (int)sizeout, (boolean)isBigEndian);
    }

    @Override
    public byte[] binaryOp(int opcode, int sizeout, int sizein1, byte[] in1, int sizein2, byte[] in2) {
        BinaryOpBehavior b = (BinaryOpBehavior)OpBehaviorFactory.getOpBehavior(opcode);
        boolean isBigEndian = this.endian.isBigEndian();
        if (sizein1 > 8 || sizein2 > 8 || sizeout > 8) {
            BigInteger in1Val = Utils.bytesToBigInteger((byte[])in1, (int)sizein1, (boolean)isBigEndian, (boolean)false);
            BigInteger in2Val = Utils.bytesToBigInteger((byte[])in2, (int)sizein2, (boolean)isBigEndian, (boolean)false);
            BigInteger outVal = b.evaluateBinary(sizeout, sizein1, in1Val, in2Val);
            return Utils.bigIntegerToBytes((BigInteger)outVal, (int)sizeout, (boolean)isBigEndian);
        }
        long in1Val = Utils.bytesToLong((byte[])in1, (int)sizein1, (boolean)isBigEndian);
        long in2Val = Utils.bytesToLong((byte[])in2, (int)sizein2, (boolean)isBigEndian);
        long outVal = b.evaluateBinary(sizeout, sizein1, in1Val, in2Val);
        return Utils.longToBytes((long)outVal, (int)sizeout, (boolean)isBigEndian);
    }

    @Override
    public byte[] modBeforeStore(int sizeinOffset, AddressSpace space, byte[] inOffset, int sizeinValue, byte[] inValue) {
        return inValue;
    }

    @Override
    public byte[] modAfterLoad(int sizeinOffset, AddressSpace space, byte[] inOffset, int sizeinValue, byte[] inValue) {
        return inValue;
    }

    @Override
    public byte[] fromConst(byte[] value) {
        return value;
    }

    @Override
    public byte[] toConcrete(byte[] value, PcodeArithmetic.Purpose purpose) {
        return value;
    }

    @Override
    public long sizeOf(byte[] value) {
        return value.length;
    }
}

