/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.symbol;

import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolIterator;
import ghidra.program.model.symbol.SymbolType;
import java.util.Iterator;

public class TypeFilteredSymbolIterator
implements SymbolIterator {
    private SymbolIterator it;
    private SymbolType type;
    private Symbol nextSymbol;

    public TypeFilteredSymbolIterator(SymbolIterator it, SymbolType type) {
        this.it = it;
        this.type = type;
    }

    @Override
    public boolean hasNext() {
        if (this.nextSymbol != null) {
            return true;
        }
        return this.findNext();
    }

    @Override
    public Symbol next() {
        if (this.hasNext()) {
            Symbol s = this.nextSymbol;
            this.nextSymbol = null;
            return s;
        }
        return null;
    }

    private boolean findNext() {
        while (this.it.hasNext()) {
            Symbol s = this.it.next();
            if (s.getSymbolType() != this.type) continue;
            this.nextSymbol = s;
            return true;
        }
        return false;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<Symbol> iterator() {
        return this;
    }
}

