/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.functiongraph.graph.layout;

import edu.uci.ics.jung.visualization.renderers.Renderer;
import ghidra.app.decompiler.DecompInterface;
import ghidra.app.decompiler.DecompileOptions;
import ghidra.app.plugin.core.functiongraph.graph.FGEdge;
import ghidra.app.plugin.core.functiongraph.graph.FunctionGraph;
import ghidra.app.plugin.core.functiongraph.graph.layout.AbstractFGLayout;
import ghidra.app.plugin.core.functiongraph.graph.layout.DNLEdgeLabelRenderer;
import ghidra.app.plugin.core.functiongraph.graph.layout.DNLayoutOptions;
import ghidra.app.plugin.core.functiongraph.graph.vertex.FGVertex;
import ghidra.app.plugin.core.functiongraph.graph.vertex.GroupedFunctionGraphVertex;
import ghidra.graph.VisualGraph;
import ghidra.graph.viewer.VisualVertex;
import ghidra.graph.viewer.layout.AbstractVisualGraphLayout;
import ghidra.graph.viewer.layout.Column;
import ghidra.graph.viewer.layout.GridLocationMap;
import ghidra.graph.viewer.layout.GridPoint;
import ghidra.graph.viewer.layout.LayoutLocationMap;
import ghidra.graph.viewer.layout.Row;
import ghidra.graph.viewer.vertex.VisualGraphVertexShapeTransformer;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.block.BasicBlockModel;
import ghidra.program.model.block.CodeBlock;
import ghidra.program.model.block.CodeBlockIterator;
import ghidra.program.model.block.CodeBlockReference;
import ghidra.program.model.block.CodeBlockReferenceIterator;
import ghidra.program.model.listing.Program;
import ghidra.program.model.pcode.BlockCopy;
import ghidra.program.model.pcode.BlockGraph;
import ghidra.program.model.pcode.PcodeBlock;
import ghidra.util.Msg;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.collections4.bidimap.DualHashBidiMap;
import org.apache.commons.collections4.map.LazyMap;

public class DecompilerNestedLayout
extends AbstractFGLayout {
    private static final int EDGE_SPACING = 5;
    private static final int VERTEX_TO_EDGE_ARTICULATION_PADDING = 20;
    private static final int VERTEX_TO_EDGE_AVOIDANCE_PADDING = 15;
    private static final int EDGE_ENDPOINT_DISTANCE_MULTIPLIER = 20;
    private static final int VERTEX_BORDER_THICKNESS = 5;
    private static final int EDGE_OFFSET_INCOMING_FROM_LEFT = 5;
    private DecompilerBlockGraph blockGraphRoot;

    public DecompilerNestedLayout(FunctionGraph graph, String name) {
        this(graph, name, true);
    }

    private DecompilerNestedLayout(FunctionGraph graph, String name, boolean initialize) {
        super(graph, name);
        if (initialize) {
            this.initialize();
        }
    }

    public Renderer.EdgeLabel<FGVertex, FGEdge> getEdgeLabelRenderer() {
        return new DNLEdgeLabelRenderer<FGVertex, FGEdge>(this.getCondenseFactor());
    }

    protected void condenseEdges(List<Row<FGVertex>> rows, Map<FGEdge, List<Point2D>> newEdgeArticulations, double centerX, double centerY) {
    }

    protected double getCondenseFactor() {
        return 0.3;
    }

    private DNLayoutOptions getLayoutOptions() {
        return (DNLayoutOptions)this.options.getLayoutOptions(this.getLayoutName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected GridLocationMap<FGVertex, FGEdge> performInitialGridLayout(VisualGraph<FGVertex, FGEdge> jungGraph) throws CancelledException {
        BlockGraph outgraph = null;
        DecompileOptions decompilerOptions = new DecompileOptions();
        DecompInterface ifc = new DecompInterface();
        try {
            ifc.setOptions(decompilerOptions);
            FGVertex aVertex = (FGVertex)jungGraph.getVertices().iterator().next();
            Program program = aVertex.getProgram();
            if (!ifc.openProgram(program)) {
                throw new RuntimeException("Unable to initialize: " + ifc.getLastMessage());
            }
            BlockGraph ingraph = this.buildCurrentFunctionGraph(program, jungGraph, this.monitor);
            if (ingraph == null) {
                throw new RuntimeException("Unable to initialize: " + ifc.getLastMessage());
            }
            outgraph = ifc.structureGraph(ingraph, 0, this.monitor);
        }
        finally {
            ifc.dispose();
        }
        if (outgraph == null) {
            throw new RuntimeException("No results from the Decompiler: " + ifc.getLastMessage());
        }
        if (outgraph.getSize() == 0) {
            throw new RuntimeException("No results from the Decompiler: " + ifc.getLastMessage());
        }
        this.blockGraphRoot = new DecompilerBlockGraph(null, outgraph);
        this.printGraphStrucure(outgraph);
        this.debug("\n\n");
        this.printParts(0, outgraph);
        this.debug("\n\n");
        this.printConvertedStructure(0, this.blockGraphRoot);
        GridLocationMap<FGVertex, FGEdge> gridLocations = this.assignCoordinates(jungGraph, this.blockGraphRoot);
        this.labelEdges(jungGraph, gridLocations, this.blockGraphRoot);
        Address entryPoint = this.function.getEntryPoint();
        FGVertex vertex = this.getVertex(jungGraph, entryPoint);
        GridPoint gridPoint = gridLocations.gridPoint((Object)vertex);
        if (gridPoint.row != 0 && gridPoint.col != 0) {
            Msg.debug((Object)((Object)this), (Object)("Function graph has entry point not at top of layout: " + String.valueOf(entryPoint)));
        }
        return gridLocations;
    }

    private void labelEdges(VisualGraph<FGVertex, FGEdge> jungGraph, GridLocationMap<FGVertex, FGEdge> gridLocations, DecompilerBlockGraph root) {
        Collection edges = jungGraph.getEdges();
        for (FGEdge e : edges) {
            boolean hasBranching;
            FGVertex start = (FGVertex)e.getStart();
            FGVertex end = (FGVertex)e.getEnd();
            Address startAddress = start.getVertexAddress();
            Address endAddress = end.getVertexAddress();
            int result = startAddress.compareTo((Object)endAddress);
            DecompilerBlock endBlock = this.blockGraphRoot.getBlock(end);
            DecompilerBlock loop = endBlock.getParentLoop();
            if (result > 0 && loop != null) {
                DecompilerBlock startBlock = root.getBlock(start);
                startBlock = startBlock.parent;
                e.setLabel(startBlock.getName());
                continue;
            }
            Integer startCol = gridLocations.col((Object)start);
            Integer endCol = gridLocations.col((Object)end);
            boolean isFallthrough = startCol >= endCol;
            Collection outEdges = jungGraph.getOutEdges((Object)start);
            boolean bl = hasBranching = outEdges.size() > 1;
            if (isFallthrough && hasBranching) continue;
            DecompilerBlock startBlock = root.getBlock(start);
            startBlock = startBlock.parent;
            e.setLabel(startBlock.getName());
        }
    }

    protected Map<FGEdge, List<Point2D>> positionEdgeArticulationsInLayoutSpace(VisualGraphVertexShapeTransformer<FGVertex> transformer, Map<FGVertex, Point2D> vertexLayoutLocations, Collection<FGEdge> edges, LayoutLocationMap<FGVertex, FGEdge> layoutToGridMap) throws CancelledException {
        HashMap<FGEdge, List<Point2D>> newEdgeArticulations = new HashMap<FGEdge, List<Point2D>>();
        int edgeOffset = this.isCondensedLayout() ? (int)(20.0 * (1.0 - this.getCondenseFactor())) : 20;
        Vertex2dFactory vertex2dFactory = new Vertex2dFactory(transformer, vertexLayoutLocations, layoutToGridMap, edgeOffset);
        for (FGEdge e : edges) {
            DecompilerBlock block;
            DecompilerBlock loop;
            boolean goingUp;
            this.monitor.checkCancelled();
            FGVertex startVertex = (FGVertex)e.getStart();
            FGVertex endVertex = (FGVertex)e.getEnd();
            Vertex2d start = vertex2dFactory.get(startVertex);
            Vertex2d end = vertex2dFactory.get(endVertex);
            boolean bl = goingUp = start.rowIndex > end.rowIndex;
            if (goingUp && (loop = (block = this.blockGraphRoot.getBlock(endVertex)).getParentLoop()) != null) {
                List<Point2D> articulations = this.routeUpwardLoop(layoutToGridMap, vertex2dFactory, start, end, loop);
                newEdgeArticulations.put(e, articulations);
                continue;
            }
            ArrayList<Point2D> articulations = new ArrayList<Point2D>();
            if (start.columnIndex < end.columnIndex) {
                this.routeToTheRight(start, end, vertex2dFactory, articulations);
            } else if (start.columnIndex > end.columnIndex) {
                if (start.rowIndex < end.rowIndex) {
                    this.routeToTheLeft(start, end, e, vertex2dFactory, articulations);
                } else {
                    this.routeToTheRightGoingUpwards(start, end, vertex2dFactory, articulations);
                }
            } else {
                this.routeDownward(start, end, e, vertex2dFactory, articulations);
            }
            newEdgeArticulations.put(e, articulations);
        }
        vertex2dFactory.dispose();
        return newEdgeArticulations;
    }

    private List<Point2D> routeUpwardLoop(LayoutLocationMap<FGVertex, FGEdge> layoutToGridMap, Vertex2dFactory vertex2dFactory, Vertex2d start, Vertex2d end, DecompilerBlock loop) {
        Set<FGVertex> loopVertices = loop.getVertices();
        FGVertex rightmostLoopVertex = this.getRightmostVertex(layoutToGridMap, vertex2dFactory, loopVertices);
        int startRow = start.rowIndex;
        int endRow = end.rowIndex;
        int startColumn = Math.min(start.columnIndex, end.columnIndex);
        int endColumn = Math.max(start.columnIndex, end.columnIndex);
        Column rightmostLoopColumn = layoutToGridMap.col((Object)rightmostLoopVertex);
        endColumn = Math.max(endColumn, rightmostLoopColumn.index);
        List<Vertex2d> interlopers = this.getVerticesInBounds(vertex2dFactory, startRow, endRow, startColumn, endColumn);
        FGVertex rightmostVertex = this.getRightmostVertex(interlopers);
        Column rightmostColumn = layoutToGridMap.col((Object)rightmostVertex);
        Column nextColumn = layoutToGridMap.nextColumn(rightmostColumn);
        Vertex2d rightmostV2d = vertex2dFactory.get(rightmostVertex);
        double rightSide = rightmostV2d.getRight() + 50.0;
        double x = Math.min(rightSide, (double)(nextColumn.x - 10));
        List<Point2D> articulations = this.routeLoopEdge(start, end, x);
        return articulations;
    }

    private List<Vertex2d> getVerticesInBounds(Vertex2dFactory vertex2dFactory, int startRow, int endRow, int startColumn, int endColumn) {
        if (startRow > endRow) {
            int temp = endRow;
            endRow = startRow;
            startRow = temp;
        }
        LinkedList<Vertex2d> toCheck = new LinkedList<Vertex2d>();
        for (int row = startRow; row < endRow + 1; ++row) {
            for (int col = startColumn; col < endColumn + 1; ++col) {
                Vertex2d otherVertex = vertex2dFactory.get(row, col);
                if (otherVertex == null) continue;
                toCheck.add(otherVertex);
            }
        }
        return toCheck;
    }

    private void routeToTheRightGoingUpwards(Vertex2d start, Vertex2d end, Vertex2dFactory vertex2dFactory, List<Point2D> articulations) {
        int delta = start.rowIndex - end.rowIndex;
        int multiplier = 20;
        if (this.useSimpleRouting()) {
            multiplier = 1;
        }
        int distanceSpacing = delta * multiplier;
        int exaggerationFactor = 1;
        if (this.isCondensedLayout()) {
            exaggerationFactor = 2;
        }
        double x1 = start.getX();
        double y1 = start.getTop() + 5.0;
        y1 += (double)(distanceSpacing *= exaggerationFactor);
        double startCenterY = start.getY() - 5.0;
        y1 = Math.min(y1, startCenterY);
        articulations.add(new Point2D.Double(x1, y1));
        double startRightX = start.getRight();
        double x2 = startRightX + 5.0;
        double y2 = y1;
        articulations.add(new Point2D.Double(x2 += (double)distanceSpacing, y2));
        this.routeAroundColumnVertices(start, end, vertex2dFactory, articulations, x2);
        double x3 = x2;
        double y3 = end.getBottom() - 5.0;
        y3 -= (double)distanceSpacing;
        double endYLimit = end.getY() + 5.0;
        y3 = Math.max(y3, endYLimit);
        articulations.add(new Point2D.Double(x3, y3));
        double x4 = end.getX();
        double y4 = y3;
        articulations.add(new Point2D.Double(x4, y4));
    }

    private void routeDownward(Vertex2d start, Vertex2d end, FGEdge e, Vertex2dFactory vertex2dFactory, List<Point2D> articulations) {
        this.lighten(e);
        int delta = end.rowIndex - start.rowIndex;
        int distanceSpacing = delta * 20;
        double x1 = start.getX() - (double)distanceSpacing;
        double y1 = start.getY();
        articulations.add(new Point2D.Double(x1, y1));
        double x2 = x1;
        double y2 = end.getY();
        articulations.add(new Point2D.Double(x2, y2));
        double x3 = end.getX() + (double)(-distanceSpacing);
        double y3 = y2;
        this.routeAroundColumnVertices(start, end, vertex2dFactory, articulations, x3);
        articulations.add(new Point2D.Double(x3, y3));
        double x4 = end.getX();
        double y4 = y3;
        articulations.add(new Point2D.Double(x4, y4));
    }

    private void routeToTheLeft(Vertex2d start, Vertex2d end, FGEdge e, Vertex2dFactory vertex2dFactory, List<Point2D> articulations) {
        this.lighten(e);
        int delta = end.rowIndex - start.rowIndex;
        int multiplier = 20;
        if (this.useSimpleRouting()) {
            multiplier = 1;
        }
        int distanceSpacing = delta * multiplier;
        double x1 = start.getX() - 5.0;
        x1 -= (double)distanceSpacing;
        double startXLimit = start.getLeft() + 5.0;
        x1 = Math.max(x1, startXLimit);
        double endRightX = end.getRight() - 5.0;
        x1 = Math.max(x1, endRightX);
        double y1 = start.getY();
        articulations.add(new Point2D.Double(x1, y1));
        double x2 = x1;
        double y2 = start.getBottom() + (double)start.getEdgeOffset();
        articulations.add(new Point2D.Double(x2, y2));
        double x3 = endRightX - 5.0;
        x3 -= (double)distanceSpacing;
        int edgeOffset = 0;
        if (this.usesEdgeArticulations()) {
            edgeOffset = 5;
        }
        double endXLimit = end.getX() + 5.0 + (double)edgeOffset;
        x3 = Math.max(x3, endXLimit);
        double y3 = y2;
        articulations.add(new Point2D.Double(x3, y3));
        this.routeAroundColumnVertices(start, end, vertex2dFactory, articulations, x3);
        double x4 = x3;
        double y4 = end.getY();
        articulations.add(new Point2D.Double(x4, y4));
    }

    private void routeToTheRight(Vertex2d start, Vertex2d end, Vertex2dFactory vertex2dFactory, List<Point2D> articulations) {
        int delta = end.rowIndex - start.rowIndex;
        if (delta < 0) {
            delta = -delta;
        }
        int multiplier = 20;
        if (this.useSimpleRouting()) {
            multiplier = 1;
        }
        int distanceSpacing = delta * multiplier;
        double startRightX = start.getRight();
        double x1 = startRightX - 5.0;
        x1 -= (double)distanceSpacing;
        double endLeftX = end.getLeft() - (double)end.getEdgeOffset();
        x1 = Math.min(x1, endLeftX);
        double startXLimit = start.getX() + 5.0;
        x1 = Math.max(x1, startXLimit);
        double y1 = start.getY();
        articulations.add(new Point2D.Double(x1, y1));
        double x2 = x1;
        double y2 = end.getTop() + 5.0;
        y2 += (double)distanceSpacing;
        double endYLimit = end.getY() - 5.0;
        y2 = Math.min(y2, endYLimit);
        articulations.add(new Point2D.Double(x2, y2));
        this.routeAroundColumnVertices(start, end, vertex2dFactory, articulations, x2);
        double x3 = x2;
        double y3 = end.getY();
        articulations.add(new Point2D.Double(x3, y3));
        double x4 = end.getX();
        double y4 = y3;
        articulations.add(new Point2D.Double(x4, y4));
    }

    private void routeAroundColumnVertices(Vertex2d start, Vertex2d end, Vertex2dFactory vertex2dFactory, List<Point2D> articulations, double edgeX) {
        if (this.useSimpleRouting()) {
            return;
        }
        boolean goingDown = true;
        int startRow = start.rowIndex;
        int endRow = end.rowIndex;
        if (startRow > endRow) {
            goingDown = false;
            endRow = start.rowIndex;
            startRow = end.rowIndex;
        }
        int startColumn = Math.min(start.columnIndex, end.columnIndex);
        int endColumn = Math.max(start.columnIndex, end.columnIndex);
        if (goingDown) {
            --endRow;
            --endColumn;
            if (start.columnIndex <= end.columnIndex) {
                ++startRow;
            }
        } else {
            Column<FGVertex> rightColumn = vertex2dFactory.getColumn(edgeX);
            endColumn = rightColumn.index;
        }
        LinkedList<Vertex2d> toCheck = new LinkedList<Vertex2d>();
        for (int row = startRow; row < endRow + 1; ++row) {
            for (int col = startColumn; col < endColumn + 1; ++col) {
                Vertex2d otherVertex = vertex2dFactory.get(row, col);
                if (otherVertex == null) continue;
                toCheck.add(otherVertex);
            }
        }
        if (!goingDown) {
            Collections.reverse(toCheck);
        }
        int delta = endRow - startRow;
        for (Vertex2d otherVertex : toCheck) {
            VertexClipper vertexClipper;
            double centerX;
            boolean goingLeft;
            int padding = 15;
            int distanceSpacing = padding + delta;
            int vertexToEdgeOffset = otherVertex.getEdgeOffset();
            int exaggerationFactor = 1;
            if (this.isCondensedLayout()) {
                exaggerationFactor = 4;
            }
            boolean bl = goingLeft = edgeX < (centerX = otherVertex.getX());
            if (!goingDown) {
                goingLeft = false;
            }
            if (!(vertexClipper = new VertexClipper(this, goingLeft, goingDown)).isClippingX(otherVertex, edgeX)) continue;
            double x = edgeX;
            double y = vertexClipper.getTopOffset(otherVertex, vertexToEdgeOffset);
            articulations.add(new Point2D.Double(x, y));
            if (articulations.size() > 2) {
                Point2D previousArticulation = articulations.get(articulations.size() - 2);
                int closenessHeight = 50;
                double previousY = previousArticulation.getY();
                if (vertexClipper.isTooCloseY(y, previousY, closenessHeight)) {
                    articulations.remove(articulations.size() - 1);
                    articulations.remove(articulations.size() - 1);
                    Point2D newPrevious = articulations.get(articulations.size() - 1);
                    y = newPrevious.getY();
                }
            }
            int offset = Math.max(vertexToEdgeOffset, distanceSpacing);
            x = vertexClipper.getSideOffset(otherVertex, offset *= exaggerationFactor);
            articulations.add(new Point2D.Double(x, y));
            y = vertexClipper.getBottomOffset(otherVertex, vertexToEdgeOffset);
            articulations.add(new Point2D.Double(x, y));
            x = edgeX;
            articulations.add(new Point2D.Double(x, y));
        }
    }

    private boolean useSimpleRouting() {
        return !this.getLayoutOptions().useEdgeRoutingAroundVertices();
    }

    private List<Point2D> routeLoopEdge(Vertex2d start, Vertex2d end, double x) {
        ArrayList<Point2D> articulations = new ArrayList<Point2D>();
        int startRow = start.rowIndex;
        int endRow = end.rowIndex;
        if (startRow > endRow) {
            endRow = start.rowIndex;
            startRow = end.rowIndex;
        }
        int delta = endRow - startRow;
        Point2D startVertexPoint = start.center;
        double y1 = startVertexPoint.getY();
        Point2D.Double first = new Point2D.Double(x += (double)delta, y1);
        articulations.add(first);
        Point2D endVertexPoint = end.center;
        double y2 = endVertexPoint.getY();
        Point2D.Double second = new Point2D.Double(x, y2);
        articulations.add(second);
        return articulations;
    }

    private void lighten(FGEdge e) {
        if (!this.getLayoutOptions().useDimmedReturnEdges()) {
            return;
        }
        e.setDefaultAlpha(0.25);
    }

    private FGVertex getRightmostVertex(LayoutLocationMap<FGVertex, FGEdge> layoutLocations, Vertex2dFactory vertex2dFactory, Set<FGVertex> vertices) {
        ArrayList<Vertex2d> points = new ArrayList<Vertex2d>();
        for (FGVertex v : vertices) {
            Vertex2d v2d = vertex2dFactory.get(v);
            points.add(v2d);
        }
        FGVertex v = this.getRightmostVertex(points);
        return v;
    }

    private FGVertex getRightmostVertex(Collection<Vertex2d> points) {
        Vertex2d rightmost = null;
        for (Vertex2d v2d : points) {
            if (rightmost == null) {
                rightmost = v2d;
                continue;
            }
            double current = rightmost.getRight();
            double other = v2d.getRight();
            if (!(other > current)) continue;
            rightmost = v2d;
        }
        return rightmost.v;
    }

    public boolean usesEdgeArticulations() {
        return true;
    }

    protected Point2D getVertexLocation(FGVertex v, Column<FGVertex> col, Row<FGVertex> row, Rectangle bounds) {
        return this.getCenteredVertexLocation((VisualVertex)v, col, row, bounds);
    }

    private void debug(String text) {
    }

    private void printParts(int depth, BlockGraph block) {
        PcodeBlock child;
        int i;
        int blockSize = block.getSize();
        this.debug(this.printDepth(0, depth) + PcodeBlock.typeToName((int)block.getType()) + "  - (" + String.valueOf(block.getStart()) + "->" + String.valueOf(block.getStop()) + ") ");
        for (i = 0; i < blockSize; ++i) {
            child = block.getBlock(i);
            StringBuilder buffy = new StringBuilder();
            buffy.append(this.printDepth(1, depth + 1)).append(' ').append(child);
            this.debug(buffy.toString());
        }
        for (i = 0; i < blockSize; ++i) {
            child = block.getBlock(i);
            if (!(child instanceof BlockGraph)) continue;
            this.printParts(depth + 1, (BlockGraph)child);
        }
    }

    private void printConvertedStructure(int depth, DecompilerBlockGraph blockGraph) {
        String depthString = this.printDepth(depth, depth);
        String blockName = blockGraph.getName();
        if (blockName != null) {
            this.debug(depthString + blockName);
            String childrenString = blockGraph.getChildrenString(depth + 1);
            if (!childrenString.isEmpty()) {
                this.debug(childrenString);
            }
        }
        List<DecompilerBlock> list = blockGraph.allChildren;
        for (DecompilerBlock block : list) {
            if (block instanceof DecompilerBlockGraph) {
                this.printConvertedStructure(depth + 1, (DecompilerBlockGraph)block);
                continue;
            }
            this.debug(depthString + "::" + block.getName());
        }
    }

    private void printGraphStrucure(BlockGraph blockGraph) {
        this.printBlock(new AtomicInteger(0), 0, blockGraph);
    }

    private void printBlock(AtomicInteger parentID, int depth, BlockGraph block) {
        this.debug(String.valueOf(parentID) + " " + this.printDepth(depth, depth) + (parentID.get() - 1) + " " + PcodeBlock.typeToName((int)block.getType()) + "  - (" + String.valueOf(block.getStart()) + "->" + String.valueOf(block.getStop()) + ") ");
        int blockSize = block.getSize();
        int ID = parentID.getAndIncrement();
        for (int i = 0; i < blockSize; ++i) {
            PcodeBlock child = block.getBlock(i);
            if (child instanceof BlockGraph) {
                this.printBlock(parentID, depth + 1, (BlockGraph)child);
                continue;
            }
            BlockCopy copy = (BlockCopy)child;
            StringBuilder buffy = new StringBuilder();
            buffy.append(this.printDepth(depth, depth + 1)).append(' ').append(ID).append(" plain - ").append(copy.getRef());
            this.debug(buffy.toString());
        }
    }

    private String printDepth(int level, int depth) {
        if (depth == 0) {
            return "";
        }
        StringBuilder buffy = new StringBuilder();
        for (int i = 0; i < depth * 2; ++i) {
            buffy.append(' ');
        }
        buffy.append(' ');
        return buffy.toString();
    }

    private GridLocationMap<FGVertex, FGEdge> assignCoordinates(VisualGraph<FGVertex, FGEdge> jungGraph, DecompilerBlockGraph root) {
        GridLocationMap gridLocations = new GridLocationMap();
        root.setCol(0);
        this.debug("\n\n");
        root.setRows(0);
        Collection vertices = jungGraph.getVertices();
        for (FGVertex vertex : vertices) {
            DecompilerBlock block = root.getBlock(vertex);
            int col = block.getCol();
            int row = block.getRow();
            gridLocations.set((Object)vertex, row, col);
        }
        return gridLocations;
    }

    private FGVertex getVertex(VisualGraph<FGVertex, FGEdge> jungGraph, Address address) {
        Collection vertices = jungGraph.getVertices();
        for (FGVertex v : vertices) {
            if (!v.containsAddress(address)) continue;
            return v;
        }
        Msg.debug((Object)((Object)this), (Object)("Unable to find vertex for address; has the program changed?: " + String.valueOf(address)));
        return null;
    }

    private BlockGraph buildCurrentFunctionGraph(Program program, VisualGraph<FGVertex, FGEdge> jungGraph, TaskMonitor taskMonitor) throws CancelledException {
        BasicBlockModel blockModel = new BasicBlockModel(program);
        AddressSetView addresses = this.function.getBody();
        CodeBlockIterator iterator = blockModel.getCodeBlocksContaining(addresses, taskMonitor);
        BlockGraph blockGraph = new BlockGraph();
        DualHashBidiMap bidiMap = new DualHashBidiMap();
        while (iterator.hasNext()) {
            taskMonitor.checkCancelled();
            CodeBlock codeBlock = iterator.next();
            FGVertex vertex = this.getVertex(jungGraph, codeBlock.getMinAddress());
            if (vertex == null) continue;
            BlockCopy pcodeBlock = new BlockCopy((Object)vertex, codeBlock.getMinAddress());
            bidiMap.put((Object)codeBlock, (Object)pcodeBlock);
            blockGraph.addBlock((PcodeBlock)pcodeBlock);
        }
        for (CodeBlock block : bidiMap.keySet()) {
            taskMonitor.checkCancelled();
            CodeBlockReferenceIterator destinations = block.getDestinations(taskMonitor);
            while (destinations.hasNext()) {
                taskMonitor.checkCancelled();
                CodeBlockReference ref = destinations.next();
                if (ref.getFlowType().isCall()) continue;
                CodeBlock destination = ref.getDestinationBlock();
                PcodeBlock sourcePcodeBlock = (PcodeBlock)bidiMap.get((Object)block);
                PcodeBlock destPcodeBlock = (PcodeBlock)bidiMap.get((Object)destination);
                if (destPcodeBlock == null) continue;
                blockGraph.addEdge(sourcePcodeBlock, destPcodeBlock);
            }
        }
        blockGraph.setIndices();
        return blockGraph;
    }

    protected AbstractVisualGraphLayout<FGVertex, FGEdge> createClonedFGLayout(FunctionGraph newGraph) {
        return new DecompilerNestedLayout(newGraph, this.getLayoutName(), false);
    }

    private DecompilerBlockGraph getDecompilerBlock(DecompilerBlockGraph parent, BlockGraph block) {
        switch (block.getType()) {
            case 0: {
                return new DecompilerBlockGraph(parent, block);
            }
            case 1: {
                return new DecompilerBlockGraph(parent, block);
            }
            case 2: {
                return new DecompilerBlockGraph(parent, block);
            }
            case 3: {
                return new PlainBlock(this, parent, block);
            }
            case 4: {
                return new DecompilerBlockGraph(parent, block);
            }
            case 5: {
                return new DecompilerBlockGraph(parent, block);
            }
            case 6: {
                return new ListBlock(this, parent, block);
            }
            case 7: {
                return new ConditionBlock(this, parent, block);
            }
            case 8: {
                return new IfBlock(this, parent, block);
            }
            case 9: {
                return new IfElseBlock(this, parent, block);
            }
            case 10: {
                return new IfBlock(this, parent, block);
            }
            case 11: {
                return new WhileLoopBlock(this, parent, block);
            }
            case 12: {
                return new DoLoopBlock(this, parent, block);
            }
            case 13: {
                return new SwitchBlock(this, parent, block);
            }
            case 14: {
                return new DecompilerBlockGraph(parent, block);
            }
        }
        throw new AssertException("Unhandled Decompiler Type: " + PcodeBlock.typeToName((int)block.getType()));
    }

    private class DecompilerBlockGraph
    extends DecompilerBlock {
        protected List<DecompilerBlock> allChildren;

        DecompilerBlockGraph(DecompilerBlockGraph parent, BlockGraph blockGraph) {
            super(DecompilerNestedLayout.this, parent, (PcodeBlock)blockGraph);
            this.allChildren = new ArrayList<DecompilerBlock>();
            int childCount = blockGraph.getSize();
            for (int i = 0; i < childCount; ++i) {
                PcodeBlock block = blockGraph.getBlock(i);
                if (block instanceof BlockGraph) {
                    DecompilerBlockGraph decompilerBlock = DecompilerNestedLayout.this.getDecompilerBlock(this, (BlockGraph)block);
                    this.allChildren.add(decompilerBlock);
                }
                if (!(block instanceof BlockCopy)) continue;
                DecompilerCopy decompilerCopy = new DecompilerCopy(DecompilerNestedLayout.this, this, (BlockCopy)block);
                this.allChildren.add(decompilerCopy);
            }
        }

        @Override
        DecompilerBlock getBlock(FGVertex vertex) {
            for (DecompilerBlock child : this.allChildren) {
                DecompilerBlock block = child.getBlock(vertex);
                if (block == null) continue;
                return block;
            }
            return null;
        }

        @Override
        DecompilerBlock getParentLoop() {
            if (this.parent == null) {
                return null;
            }
            return this.parent.getParentLoop();
        }

        @Override
        Set<FGVertex> getVertices() {
            HashSet<FGVertex> set = new HashSet<FGVertex>();
            for (DecompilerBlock child : this.allChildren) {
                set.addAll(child.getVertices());
            }
            return set;
        }

        @Override
        void setCol(int col) {
            for (int i = 0; i < this.allChildren.size(); ++i) {
                int column = i == 0 ? col : col + 1;
                DecompilerBlock block = this.allChildren.get(i);
                block.setCol(column);
            }
            this.doSetCol(col);
        }

        protected void doSetCol(int col) {
            super.setCol(col);
        }

        int setRows(int startRow) {
            int row = startRow;
            for (DecompilerBlock block : this.allChildren) {
                if (block instanceof DecompilerBlockGraph) {
                    row = ((DecompilerBlockGraph)block).setRows(row);
                    continue;
                }
                block.setRow(row++);
            }
            return row;
        }

        @Override
        String getName() {
            return null;
        }

        @Override
        String getChildrenString(int depth) {
            StringBuilder buffy = new StringBuilder();
            int childCount = 0;
            for (DecompilerBlock block : this.allChildren) {
                String blockName;
                if (!(block instanceof DecompilerBlockGraph) || (blockName = block.getName()) == null) continue;
                if (++childCount > 1) {
                    buffy.append('\n');
                }
                buffy.append(DecompilerNestedLayout.this.printDepth(depth, depth));
                buffy.append(' ');
                buffy.append(blockName);
            }
            return buffy.toString();
        }
    }

    private abstract class DecompilerBlock {
        protected DecompilerBlock parent;
        protected PcodeBlock pcodeBlock;
        private int row;
        private int col;

        DecompilerBlock(DecompilerNestedLayout decompilerNestedLayout, DecompilerBlock parent, PcodeBlock pcodeBlock) {
            this.parent = parent;
            this.pcodeBlock = pcodeBlock;
        }

        void setRow(int row) {
            this.row = row;
        }

        void setCol(int col) {
            this.col = col;
        }

        int getRow() {
            return this.row;
        }

        int getCol() {
            return this.col;
        }

        abstract DecompilerBlock getBlock(FGVertex var1);

        abstract Set<FGVertex> getVertices();

        abstract DecompilerBlock getParentLoop();

        abstract String getName();

        abstract String getChildrenString(int var1);

        public String toString() {
            return PcodeBlock.typeToName((int)this.pcodeBlock.getType()) + " - " + this.getName() + " - " + String.valueOf(this.pcodeBlock.getStart());
        }
    }

    private class Vertex2dFactory {
        private VisualGraphVertexShapeTransformer<FGVertex> vertexShaper;
        private Map<FGVertex, Point2D> vertexLayoutLocations;
        private LayoutLocationMap<FGVertex, FGEdge> layoutToGridMap;
        private int edgeOffset;
        private Map<FGVertex, Vertex2d> cache = LazyMap.lazyMap(new HashMap(), v -> new Vertex2d(DecompilerNestedLayout.this, (FGVertex)v, this.vertexShaper, this.vertexLayoutLocations, this.layoutToGridMap, this.getEdgeOffset()));

        Vertex2dFactory(VisualGraphVertexShapeTransformer<FGVertex> transformer, Map<FGVertex, Point2D> vertexLayoutLocations, LayoutLocationMap<FGVertex, FGEdge> layoutToGridMap, int edgeOffset) {
            this.vertexShaper = transformer;
            this.vertexLayoutLocations = vertexLayoutLocations;
            this.layoutToGridMap = layoutToGridMap;
            this.edgeOffset = edgeOffset;
        }

        Column<FGVertex> getColumn(double x) {
            return this.layoutToGridMap.getColumnContaining((int)x);
        }

        private int getEdgeOffset() {
            return this.edgeOffset;
        }

        Vertex2d get(FGVertex v) {
            return this.cache.get(v);
        }

        Vertex2d get(int rowIndex, int columnIndex) {
            Row row = this.layoutToGridMap.row(rowIndex);
            FGVertex v = (FGVertex)row.getVertex(columnIndex);
            if (v == null) {
                return null;
            }
            return this.get(v);
        }

        void dispose() {
            this.cache.clear();
        }
    }

    private class Vertex2d {
        private FGVertex v;
        private Row<FGVertex> row;
        private Column<FGVertex> column;
        private int rowIndex;
        private int columnIndex;
        private Point2D center;
        private Shape shape;
        private Rectangle bounds;
        private int edgeOffset;

        Vertex2d(DecompilerNestedLayout decompilerNestedLayout, FGVertex v, VisualGraphVertexShapeTransformer<FGVertex> transformer, Map<FGVertex, Point2D> vertexLayoutLocations, LayoutLocationMap<FGVertex, FGEdge> layoutLocations, int edgeOffset) {
            this.v = v;
            this.row = layoutLocations.row((Object)v);
            this.rowIndex = this.row.index;
            this.column = layoutLocations.col((Object)v);
            this.columnIndex = this.column.index;
            this.center = vertexLayoutLocations.get(v);
            this.shape = transformer.apply((VisualVertex)v);
            this.bounds = this.shape.getBounds();
            this.edgeOffset = edgeOffset;
            double cornerX = this.center.getX() + this.bounds.getWidth() / 2.0;
            double cornerY = this.center.getY() + this.bounds.getHeight() / 2.0;
            Point2D.Double corner = new Point2D.Double(cornerX, cornerY);
            this.bounds.setFrameFromCenter(this.center, corner);
        }

        double getY() {
            return this.center.getY();
        }

        double getX() {
            return this.center.getX();
        }

        double getLeft() {
            return this.center.getX() - (double)(this.bounds.width >> 1);
        }

        double getRight() {
            return this.center.getX() + (double)(this.bounds.width >> 1);
        }

        double getBottom() {
            return this.center.getY() + (double)(this.bounds.height >> 1);
        }

        double getTop() {
            return this.center.getY() - (double)(this.bounds.height >> 1);
        }

        int getEdgeOffset() {
            return this.edgeOffset;
        }

        public String toString() {
            return this.v.toString();
        }
    }

    private class VertexClipper {
        boolean goingLeft;
        boolean goingDown;

        VertexClipper(DecompilerNestedLayout decompilerNestedLayout, boolean isLeft, boolean isBottom) {
            this.goingLeft = isLeft;
            this.goingDown = isBottom;
        }

        private double getSide(Vertex2d v) {
            return this.goingLeft ? v.getLeft() : v.getRight();
        }

        double getTopOffset(Vertex2d v, int offset) {
            return this.goingDown ? v.getTop() - (double)offset : v.getBottom() + (double)offset;
        }

        double getBottomOffset(Vertex2d v, int offset) {
            return this.goingDown ? v.getBottom() + (double)offset : v.getTop() - (double)offset;
        }

        double getSideOffset(Vertex2d v, int offset) {
            double side = this.getSide(v);
            if (this.goingLeft) {
                return side - (double)offset;
            }
            return side + (double)offset;
        }

        boolean isTooCloseY(double topY, double bottomY, double threshold) {
            double delta = this.goingDown ? topY - bottomY : bottomY - topY;
            return delta < threshold;
        }

        boolean isClippingX(Vertex2d v, double x) {
            double side = this.getSide(v);
            if (this.goingLeft) {
                return x >= side;
            }
            return x < side;
        }
    }

    private class PlainBlock
    extends DecompilerBlockGraph {
        PlainBlock(DecompilerNestedLayout decompilerNestedLayout, DecompilerBlockGraph parent, BlockGraph block) {
            super(parent, block);
        }

        @Override
        String getName() {
            return "Plain";
        }
    }

    private class ListBlock
    extends DecompilerBlockGraph {
        ListBlock(DecompilerNestedLayout decompilerNestedLayout, DecompilerBlockGraph parent, BlockGraph block) {
            super(parent, block);
        }

        @Override
        void setCol(int col) {
            for (DecompilerBlock block : this.allChildren) {
                int column = col;
                block.setCol(column);
            }
            this.doSetCol(col);
        }

        @Override
        String getName() {
            return this.parent.getName();
        }
    }

    private class ConditionBlock
    extends DecompilerBlockGraph {
        ConditionBlock(DecompilerNestedLayout decompilerNestedLayout, DecompilerBlockGraph parent, BlockGraph blockGraph) {
            super(parent, blockGraph);
        }

        @Override
        void setCol(int col) {
            int column = col;
            for (DecompilerBlock block : this.allChildren) {
                block.setCol(column);
                ++column;
            }
            this.doSetCol(col);
        }

        @Override
        String getName() {
            return "Condition";
        }
    }

    private class IfBlock
    extends DecompilerBlockGraph {
        IfBlock(DecompilerNestedLayout decompilerNestedLayout, DecompilerBlockGraph parent, BlockGraph blockGraph) {
            super(parent, blockGraph);
        }

        @Override
        String getName() {
            return "If";
        }
    }

    private class IfElseBlock
    extends DecompilerBlockGraph {
        IfElseBlock(DecompilerNestedLayout decompilerNestedLayout, DecompilerBlockGraph parent, BlockGraph blockGraph) {
            super(parent, blockGraph);
        }

        @Override
        String getName() {
            return "If / Else";
        }
    }

    private class WhileLoopBlock
    extends DecompilerLoop {
        WhileLoopBlock(DecompilerNestedLayout decompilerNestedLayout, DecompilerBlockGraph parent, BlockGraph blockGraph) {
            super(decompilerNestedLayout, parent, blockGraph);
        }

        @Override
        String getName() {
            return "While Loop";
        }
    }

    private class DoLoopBlock
    extends DecompilerLoop {
        DoLoopBlock(DecompilerNestedLayout decompilerNestedLayout, DecompilerBlockGraph parent, BlockGraph blockGraph) {
            super(decompilerNestedLayout, parent, blockGraph);
        }

        @Override
        void setCol(int col) {
            int column = col + 1;
            for (DecompilerBlock block : this.allChildren) {
                block.setCol(column);
            }
            this.doSetCol(col);
        }

        @Override
        String getName() {
            return "Do Loop";
        }
    }

    private class SwitchBlock
    extends DecompilerBlockGraph {
        SwitchBlock(DecompilerNestedLayout decompilerNestedLayout, DecompilerBlockGraph parent, BlockGraph blockGraph) {
            super(parent, blockGraph);
        }

        @Override
        String getName() {
            return "Switch";
        }
    }

    private abstract class DecompilerLoop
    extends DecompilerBlockGraph {
        DecompilerLoop(DecompilerNestedLayout decompilerNestedLayout, DecompilerBlockGraph parent, BlockGraph block) {
            super(parent, block);
        }

        @Override
        DecompilerBlock getParentLoop() {
            return this;
        }
    }

    private class DecompilerCopy
    extends DecompilerBlock {
        private BlockCopy copy;
        private Set<FGVertex> vertexSet = new HashSet<FGVertex>();

        DecompilerCopy(DecompilerNestedLayout decompilerNestedLayout, DecompilerBlockGraph parent, BlockCopy copy) {
            super(decompilerNestedLayout, parent, (PcodeBlock)copy);
            this.copy = copy;
            this.vertexSet.add((FGVertex)copy.getRef());
            this.vertexSet = Collections.unmodifiableSet(this.vertexSet);
        }

        FGVertex getVertex() {
            return (FGVertex)this.copy.getRef();
        }

        @Override
        DecompilerBlock getBlock(FGVertex vertex) {
            if (vertex instanceof GroupedFunctionGraphVertex) {
                Set vertices = ((GroupedFunctionGraphVertex)vertex).getVertices();
                for (FGVertex collapsedVertex : vertices) {
                    DecompilerBlock block = this.getBlock(collapsedVertex);
                    if (block == null) continue;
                    return block;
                }
            }
            FGVertex myVertex = this.getVertex();
            DecompilerBlock block = this.compareToMyVertex(myVertex, vertex);
            return block;
        }

        private DecompilerBlock compareToMyVertex(FGVertex myVertex, FGVertex vertex) {
            if (myVertex instanceof GroupedFunctionGraphVertex) {
                Set vertices = ((GroupedFunctionGraphVertex)myVertex).getVertices();
                for (FGVertex myCollapsedVertex : vertices) {
                    DecompilerBlock block = this.compareToMyVertex(myCollapsedVertex, vertex);
                    if (block == null) continue;
                    return block;
                }
            }
            if (myVertex.equals((Object)vertex)) {
                return this;
            }
            return null;
        }

        @Override
        DecompilerBlock getParentLoop() {
            return this.parent.getParentLoop();
        }

        @Override
        Set<FGVertex> getVertices() {
            return this.vertexSet;
        }

        @Override
        String getName() {
            return "Copy";
        }

        @Override
        String getChildrenString(int depth) {
            return null;
        }
    }
}

