/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.struct;

import java.util.LinkedList;
import java.util.List;

public class StringTree {
    Branch root = new Branch(this);

    public static StringTree single(CharSequence seq) {
        StringTree st = new StringTree();
        st.append(seq);
        return st;
    }

    public void append(CharSequence seq) {
        this.root.addChild(new Leaf(this, seq));
    }

    public void append(StringTree tree) {
        this.root.addChild(tree.root);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        this.root.walk(buf);
        return buf.toString();
    }

    class Branch
    implements Node {
        List<Node> children = new LinkedList<Node>();

        Branch(StringTree this$0) {
        }

        void addChild(Node child) {
            this.children.add(child);
        }

        @Override
        public void walk(StringBuffer buf) {
            for (Node child : this.children) {
                child.walk(buf);
            }
        }
    }

    class Leaf
    implements Node {
        final CharSequence seq;

        public Leaf(StringTree this$0, CharSequence seq) {
            this.seq = seq;
        }

        @Override
        public void walk(StringBuffer buf) {
            buf.append(this.seq);
        }
    }

    static interface Node {
        public void walk(StringBuffer var1);
    }
}

