/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.data;

import ghidra.framework.data.DefaultProjectData;
import ghidra.framework.data.GhidraFile;
import ghidra.framework.data.GhidraFileData;
import ghidra.framework.data.GhidraFolderData;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainFolder;
import ghidra.framework.model.DomainFolderChangeListener;
import ghidra.framework.store.FolderItem;
import ghidra.util.Msg;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.HashMap;

class DomainFileIndex
implements DomainFolderChangeListener {
    private DefaultProjectData projectData;
    private HashMap<String, String> fileIdToPathIndex = new HashMap();

    DomainFileIndex(DefaultProjectData projectData) {
        this.projectData = projectData;
    }

    private void updateFileEntry(GhidraFile df) {
        this.updateFileEntry(df, df.getFileID(), df.getPathname());
    }

    void updateFileEntry(GhidraFileData dfd) {
        this.updateFileEntry(dfd.getDomainFile(), dfd.getFileID(), dfd.getPathname());
    }

    void removeFileEntry(String fileID) {
        this.fileIdToPathIndex.remove(fileID);
    }

    private void updateFileEntry(GhidraFile df, String id, String newPath) {
        if (id != null) {
            String oldPath = this.fileIdToPathIndex.get(id);
            if (oldPath == null) {
                this.fileIdToPathIndex.put(id, newPath);
            } else {
                if (oldPath.equals(newPath)) {
                    return;
                }
                GhidraFile oldDf = (GhidraFile)this.projectData.getFile(oldPath);
                if (oldDf == null) {
                    this.fileIdToPathIndex.put(id, newPath);
                } else {
                    this.reconcileFileIDConflict(df, oldDf);
                }
            }
        }
    }

    private void reconcileFileIDConflict(GhidraFile df1, GhidraFile df2) {
        try {
            String path1 = df1.getPathname();
            String path2 = df2.getPathname();
            if (!df1.isCheckedOut() && !df1.isVersioned()) {
                Msg.warn((Object)this, (Object)("WARNING! changing file-ID for " + path1));
                df1.resetFileID();
            } else if (!df2.isCheckedOut() && !df2.isVersioned()) {
                Msg.warn((Object)this, (Object)("WARNING! changing file-ID for " + path2));
                df2.resetFileID();
            } else {
                Msg.error((Object)this, (Object)("The following project files have conflicting file-IDs!\n" + path1 + "\n" + path2));
            }
            this.fileIdToPathIndex.put(df1.getFileID(), path1);
            this.fileIdToPathIndex.put(df2.getFileID(), path2);
        }
        catch (IOException e) {
            Msg.error((Object)this, (Object)"Error while resolving file IDs", (Throwable)e);
            e.printStackTrace();
        }
    }

    DomainFile getFileByID(String fileID) {
        FolderItem item;
        TaskMonitor monitor = this.projectData.getProjectDisposalMonitor();
        String filePath = this.fileIdToPathIndex.get(fileID);
        if (filePath != null) {
            return this.projectData.getFile(filePath);
        }
        boolean unsupportedOperation = false;
        IOException exc = null;
        try {
            item = this.projectData.getPrivateFileSystem().getItem(fileID);
            if (item != null) {
                return this.projectData.getFile(item.getPathName());
            }
        }
        catch (UnsupportedOperationException e) {
            unsupportedOperation = true;
        }
        catch (IOException e) {
            exc = e;
        }
        try {
            item = this.projectData.getVersionedFileSystem().getItem(fileID);
            if (item != null) {
                return this.projectData.getFile(item.getPathName());
            }
            return null;
        }
        catch (UnsupportedOperationException e) {
            unsupportedOperation = true;
        }
        catch (IOException e) {
            exc = e;
        }
        if (unsupportedOperation) {
            try {
                return this.findFileByID(this.projectData.getRootFolderData(), fileID, monitor);
            }
            catch (IOException e) {
                exc = e;
            }
        }
        if (exc != null) {
            Msg.error((Object)this, (Object)("File index lookup failed due to error: " + exc.getMessage()));
        }
        return null;
    }

    private DomainFile findFileByID(GhidraFolderData folderData, String fileID, TaskMonitor monitor) throws IOException {
        Object filePath;
        if (!folderData.visited()) {
            folderData.refresh(false, true, monitor);
            filePath = this.fileIdToPathIndex.get(fileID);
            if (filePath != null) {
                return this.projectData.getFile((String)filePath);
            }
        }
        for (String name : folderData.getFolderNames()) {
            DomainFile df;
            if (monitor.isCancelled()) {
                return null;
            }
            GhidraFolderData subfolderData = folderData.getFolderData(name, true);
            if (subfolderData == null || (df = this.findFileByID(subfolderData, fileID, monitor)) == null) continue;
            return df;
        }
        filePath = this.fileIdToPathIndex.get(fileID);
        if (filePath != null) {
            return this.projectData.getFile((String)filePath);
        }
        return null;
    }

    @Override
    public void domainFileAdded(DomainFile file) {
        this.updateFileEntry((GhidraFile)file);
    }

    @Override
    public void domainFileMoved(DomainFile file, DomainFolder oldParent, String oldName) {
        this.updateFileEntry((GhidraFile)file);
    }

    @Override
    public void domainFileRemoved(DomainFolder parent, String name, String fileID) {
        this.fileIdToPathIndex.remove(fileID);
    }

    @Override
    public void domainFileRenamed(DomainFile file, String oldName) {
        this.updateFileEntry((GhidraFile)file);
    }

    @Override
    public void domainFileStatusChanged(DomainFile file, boolean fileIDset) {
        if (fileIDset) {
            this.updateFileEntry((GhidraFile)file);
        }
    }
}

