/*
 * Decompiled with CFR 0.152.
 */
package ghidra.debug.api.tracemgr;

import ghidra.app.services.DebuggerTraceManagerService;
import ghidra.debug.api.target.Target;
import ghidra.framework.data.DefaultProjectData;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.ProjectData;
import ghidra.framework.model.ProjectLocator;
import ghidra.framework.options.SaveState;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.store.LockException;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.Trace;
import ghidra.trace.model.guest.TracePlatform;
import ghidra.trace.model.program.TraceProgramView;
import ghidra.trace.model.stack.TraceObjectStackFrame;
import ghidra.trace.model.stack.TraceStack;
import ghidra.trace.model.stack.TraceStackFrame;
import ghidra.trace.model.target.TraceObject;
import ghidra.trace.model.target.path.KeyPath;
import ghidra.trace.model.thread.TraceObjectThread;
import ghidra.trace.model.thread.TraceThread;
import ghidra.trace.model.time.TraceSnapshot;
import ghidra.trace.model.time.schedule.TraceSchedule;
import ghidra.util.Msg;
import ghidra.util.NotOwnerException;
import java.io.IOException;
import java.util.Collection;
import java.util.Comparator;
import java.util.Objects;
import org.jdom.Element;

public class DebuggerCoordinates {
    public static final DebuggerCoordinates NOWHERE = new DebuggerCoordinates(null, null, null, null, null, null, null, null);
    private static final String KEY_TRACE_PROJ_LOC = "TraceProjLoc";
    private static final String KEY_TRACE_PROJ_NAME = "TraceProjName";
    private static final String KEY_TRACE_PATH = "TracePath";
    private static final String KEY_TRACE_VERSION = "TraceVersion";
    private static final String KEY_THREAD_KEY = "ThreadKey";
    private static final String KEY_TIME = "Time";
    private static final String KEY_FRAME = "Frame";
    private static final String KEY_OBJ_PATH = "ObjectPath";
    private final Trace trace;
    private final TracePlatform platform;
    private final Target target;
    private final TraceThread thread;
    private final TraceProgramView view;
    private final TraceSchedule time;
    private final Integer frame;
    private final KeyPath path;
    private final int hash;
    private Long viewSnap;
    private TraceObject object;
    private TraceObject registerContainer;

    public static boolean equalsIgnoreTargetAndView(DebuggerCoordinates a, DebuggerCoordinates b) {
        if (!Objects.equals(a.trace, b.trace)) {
            return false;
        }
        if (!Objects.equals(a.platform, b.platform)) {
            return false;
        }
        if (!Objects.equals(a.thread, b.thread)) {
            return false;
        }
        if (!Objects.equals(a.getTime(), b.getTime())) {
            return false;
        }
        if (!Objects.equals(a.getFrame(), b.getFrame())) {
            return false;
        }
        return Objects.equals(a.getObject(), b.getObject());
    }

    DebuggerCoordinates(Trace trace, TracePlatform platform, Target target, TraceThread thread, TraceProgramView view, TraceSchedule time, Integer frame, KeyPath path) {
        this.trace = trace;
        this.platform = platform;
        this.target = target;
        this.thread = thread;
        this.view = view;
        this.time = time;
        this.frame = frame;
        this.path = path;
        this.hash = Objects.hash(trace, target, thread, view, time, frame, path);
    }

    public String toString() {
        return String.format("Coords(trace=%s,target=%s,thread=%s,view=%s,time=%s,frame=%d,path=%s)", this.trace, this.target, this.thread, this.view, this.time, this.frame, this.path);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DebuggerCoordinates)) {
            return false;
        }
        DebuggerCoordinates that = (DebuggerCoordinates)obj;
        if (!Objects.equals(this.trace, that.trace)) {
            return false;
        }
        if (!Objects.equals(this.platform, that.platform)) {
            return false;
        }
        if (!Objects.equals(this.target, that.target)) {
            return false;
        }
        if (!Objects.equals(this.thread, that.thread)) {
            return false;
        }
        if (!Objects.equals(this.view, that.view)) {
            return false;
        }
        if (!Objects.equals(this.time, that.time)) {
            return false;
        }
        if (!Objects.equals(this.frame, that.frame)) {
            return false;
        }
        return Objects.equals(this.path, that.path);
    }

    public int hashCode() {
        return this.hash;
    }

    private static TracePlatform resolvePlatform(Trace trace) {
        return trace.getPlatformManager().getHostPlatform();
    }

    private static TraceThread resolveThread(Trace trace, TraceSchedule time) {
        long snap = time.getSnap();
        return trace.getThreadManager().getLiveThreads(snap).stream().sorted(Comparator.comparing(TraceThread::getKey)).findFirst().orElse(null);
    }

    private static TraceThread resolveThread(Trace trace) {
        return DebuggerCoordinates.resolveThread(trace, TraceSchedule.ZERO);
    }

    private static KeyPath resolvePath(Trace trace, TraceThread thread, Integer frame, TraceSchedule time) {
        KeyPath path = DebuggerCoordinates.resolvePath(thread, frame, time);
        if (path != null) {
            return path;
        }
        return KeyPath.of((String[])new String[0]);
    }

    private static TraceProgramView resolveView(Trace trace, TraceSchedule time) {
        return trace.getProgramView();
    }

    private static TraceProgramView resolveView(Trace trace) {
        return DebuggerCoordinates.resolveView(trace, TraceSchedule.ZERO);
    }

    public DebuggerCoordinates trace(Trace newTrace) {
        if (newTrace == null) {
            return NOWHERE;
        }
        if (this.trace == newTrace) {
            return this;
        }
        if (this.trace == null) {
            TracePlatform newPlatform = DebuggerCoordinates.resolvePlatform(newTrace);
            TraceThread newThread = DebuggerCoordinates.resolveThread(newTrace);
            TraceProgramView newView = DebuggerCoordinates.resolveView(newTrace);
            TraceSchedule newTime = null;
            Integer newFrame = DebuggerCoordinates.resolveFrame(newThread, newTime);
            KeyPath newPath = DebuggerCoordinates.resolvePath(newTrace, newThread, newFrame, newTime);
            return new DebuggerCoordinates(newTrace, newPlatform, null, newThread, newView, newTime, newFrame, newPath);
        }
        throw new IllegalArgumentException("Cannot change trace");
    }

    private static TraceThread resolveThread(Target target, TraceSchedule time) {
        if (target.getSnap() != time.getSnap() || !target.isSupportsFocus()) {
            return DebuggerCoordinates.resolveThread(target.getTrace(), time);
        }
        return DebuggerCoordinates.resolveThread(target, target.getFocus());
    }

    private static TraceThread resolveThread(Trace trace, Target target, TraceSchedule time) {
        if (target == null) {
            return DebuggerCoordinates.resolveThread(trace, time);
        }
        return DebuggerCoordinates.resolveThread(target, time);
    }

    private static Integer resolveFrame(TraceThread thread, TraceSchedule time) {
        return null;
    }

    private static Integer resolveFrame(Target target, TraceThread thread, TraceSchedule time) {
        if (target == null || target.getSnap() != time.getSnap() || !target.isSupportsFocus()) {
            return DebuggerCoordinates.resolveFrame(thread, time);
        }
        return DebuggerCoordinates.resolveFrame(target, target.getFocus());
    }

    private static KeyPath resolvePath(Target target, TraceThread thread, Integer frame, TraceSchedule time) {
        if (target.getSnap() != time.getSnap() || !target.isSupportsFocus()) {
            return DebuggerCoordinates.resolvePath(target.getTrace(), thread, frame, time);
        }
        return target.getFocus();
    }

    public DebuggerCoordinates platform(TracePlatform newPlatform) {
        if (this.platform == newPlatform) {
            return this;
        }
        if (newPlatform == null) {
            if (this.trace == null) {
                return NOWHERE;
            }
            return new DebuggerCoordinates(this.trace, DebuggerCoordinates.resolvePlatform(this.trace), this.target, this.thread, this.view, this.time, this.frame, this.path);
        }
        if (this.trace == null) {
            Trace newTrace = newPlatform.getTrace();
            TraceThread newThread = DebuggerCoordinates.resolveThread(newTrace);
            TraceProgramView newView = DebuggerCoordinates.resolveView(newTrace);
            TraceSchedule newTime = null;
            Integer newFrame = DebuggerCoordinates.resolveFrame(newThread, newTime);
            KeyPath newPath = DebuggerCoordinates.resolvePath(newTrace, newThread, newFrame, newTime);
            return new DebuggerCoordinates(newTrace, newPlatform, null, newThread, newView, newTime, newFrame, newPath);
        }
        if (this.trace != newPlatform.getTrace()) {
            throw new IllegalArgumentException("Cannot change trace");
        }
        return new DebuggerCoordinates(this.trace, newPlatform, this.target, this.thread, this.view, this.time, this.frame, this.path);
    }

    public DebuggerCoordinates target(Target newTarget) {
        if (this.target == newTarget) {
            return this;
        }
        if (newTarget == null) {
            return new DebuggerCoordinates(this.trace, this.platform, newTarget, this.thread, this.view, this.time, this.frame, this.path);
        }
        if (newTarget != null && this.trace != null && newTarget.getTrace() != this.trace) {
            throw new IllegalArgumentException("Cannot change trace");
        }
        Trace newTrace = this.trace != null ? this.trace : newTarget.getTrace();
        TracePlatform newPlatform = this.platform != null ? this.platform : DebuggerCoordinates.resolvePlatform(newTrace);
        TraceSchedule newTime = this.time != null ? this.time : TraceSchedule.snap((long)newTarget.getSnap());
        TraceThread newThread = this.thread != null ? this.thread : DebuggerCoordinates.resolveThread(newTarget, newTime);
        TraceProgramView newView = this.view != null ? this.view : DebuggerCoordinates.resolveView(newTrace, newTime);
        Integer newFrame = this.frame != null ? this.frame : DebuggerCoordinates.resolveFrame(newTarget, newThread, newTime);
        KeyPath threadOrFramePath = DebuggerCoordinates.resolvePath(newTarget, newThread, newFrame, newTime);
        KeyPath newPath = DebuggerCoordinates.choose(this.path, threadOrFramePath);
        return new DebuggerCoordinates(newTrace, newPlatform, newTarget, newThread, newView, newTime, newFrame, newPath);
    }

    public DebuggerCoordinates reFindThread() {
        if (this.trace == null || this.thread == null) {
            return this;
        }
        return this.thread(this.trace.getThreadManager().getThread(this.thread.getKey()));
    }

    private static KeyPath resolvePath(TraceThread thread, Integer frameLevel, TraceSchedule time) {
        if (thread instanceof TraceObjectThread) {
            TraceStack stack;
            TraceObjectThread tot = (TraceObjectThread)thread;
            TraceObject objThread = tot.getObject();
            if (frameLevel == null) {
                return objThread.getCanonicalPath();
            }
            long snap = time.getSnap();
            try {
                stack = thread.getTrace().getStackManager().getStack(thread, snap, false);
            }
            catch (IllegalStateException e) {
                return objThread.getCanonicalPath();
            }
            if (stack == null) {
                return objThread.getCanonicalPath();
            }
            TraceStackFrame frame = stack.getFrame(snap, frameLevel.intValue(), false);
            if (frame == null) {
                return objThread.getCanonicalPath();
            }
            return ((TraceObjectStackFrame)frame).getObject().getCanonicalPath();
        }
        return null;
    }

    private static KeyPath choose(KeyPath curPath, KeyPath newPath) {
        if (curPath == null) {
            return newPath;
        }
        if (newPath == null) {
            return curPath;
        }
        if (newPath.isAncestor(curPath)) {
            return curPath;
        }
        return newPath;
    }

    public DebuggerCoordinates thread(TraceThread newThread) {
        if (this.thread == newThread) {
            return this;
        }
        if (newThread != null && this.trace != null && this.trace != newThread.getTrace()) {
            throw new IllegalArgumentException("Cannot change trace");
        }
        if (newThread == null) {
            newThread = DebuggerCoordinates.resolveThread(this.trace, this.target, this.getTime());
        }
        Trace newTrace = this.trace != null ? this.trace : newThread.getTrace();
        TracePlatform newPlatform = this.platform != null ? this.platform : DebuggerCoordinates.resolvePlatform(newTrace);
        TraceSchedule newTime = this.time != null ? this.time : DebuggerCoordinates.resolveTime(this.view);
        TraceProgramView newView = this.view != null ? this.view : DebuggerCoordinates.resolveView(newTrace, newTime);
        Integer newFrame = DebuggerCoordinates.resolveFrame(this.target, newThread, newTime);
        KeyPath threadOrFramePath = DebuggerCoordinates.resolvePath(newThread, newFrame, newTime);
        KeyPath newPath = DebuggerCoordinates.choose(this.path, threadOrFramePath);
        return new DebuggerCoordinates(newTrace, newPlatform, this.target, newThread, newView, newTime, newFrame, newPath);
    }

    public DebuggerCoordinates snap(long snap) {
        return this.time(TraceSchedule.snap((long)snap));
    }

    public DebuggerCoordinates snapNoResolve(long snap) {
        if (this.time != null && this.time.isSnapOnly() && this.time.getSnap() == snap) {
            return this;
        }
        TraceSchedule newTime = TraceSchedule.snap((long)snap);
        return new DebuggerCoordinates(this.trace, this.platform, this.target, this.thread, this.view, newTime, this.frame, this.path);
    }

    public DebuggerCoordinates time(TraceSchedule newTime) {
        if (Objects.equals(this.time, newTime)) {
            return this;
        }
        if (this.trace == null) {
            return NOWHERE;
        }
        long snap = newTime.getSnap();
        boolean isThreadValid = this.thread == null ? false : this.thread.isValid(snap);
        TraceThread newThread = isThreadValid ? this.thread : DebuggerCoordinates.resolveThread(this.trace, this.target, newTime);
        Integer newFrame = DebuggerCoordinates.resolveFrame(newThread, newTime);
        KeyPath threadOrFramePath = DebuggerCoordinates.resolvePath(newThread, newFrame, newTime);
        KeyPath newPath = DebuggerCoordinates.choose(this.path, threadOrFramePath);
        return new DebuggerCoordinates(this.trace, this.platform, this.target, newThread, this.view, newTime, newFrame, newPath);
    }

    public boolean differsOnlyByPatch(DebuggerCoordinates that) {
        if (!Objects.equals(this.trace, that.trace)) {
            return false;
        }
        if (!Objects.equals(this.platform, that.platform)) {
            return false;
        }
        if (!Objects.equals(this.thread, that.thread)) {
            return false;
        }
        if (!Objects.equals(this.getFrame(), that.getFrame())) {
            return false;
        }
        if (!Objects.equals(this.getObject(), that.getObject())) {
            return false;
        }
        return this.getTime().differsOnlyByPatch(that.getTime());
    }

    public DebuggerCoordinates frame(int newFrame) {
        if (this.trace == null) {
            return NOWHERE;
        }
        if (Objects.equals(this.frame, newFrame)) {
            return this;
        }
        KeyPath threadOrFramePath = DebuggerCoordinates.resolvePath(this.thread, newFrame, this.getTime());
        KeyPath newPath = DebuggerCoordinates.choose(this.path, threadOrFramePath);
        return new DebuggerCoordinates(this.trace, this.platform, this.target, this.thread, this.view, this.time, newFrame, newPath);
    }

    public DebuggerCoordinates frame(Integer newFrame) {
        if (newFrame == null) {
            return this;
        }
        return this.frame((int)newFrame);
    }

    private DebuggerCoordinates replaceView(TraceProgramView newView) {
        return new DebuggerCoordinates(this.trace, this.platform, this.target, this.thread, newView, this.time, this.frame, this.path);
    }

    private static TraceSchedule resolveTime(TraceProgramView view) {
        if (view == null) {
            return null;
        }
        long snap = view.getSnap();
        if (!Lifespan.isScratch((long)snap)) {
            return TraceSchedule.snap((long)snap);
        }
        TraceSnapshot snapshot = view.getTrace().getTimeManager().getSnapshot(snap, false);
        if (snapshot == null) {
            return TraceSchedule.snap((long)snap);
        }
        TraceSchedule schedule = snapshot.getSchedule();
        if (schedule == null) {
            return TraceSchedule.snap((long)snap);
        }
        return schedule;
    }

    public DebuggerCoordinates view(TraceProgramView newView) {
        if (this.view == newView) {
            return this;
        }
        if (this.trace == null) {
            if (newView == null) {
                return NOWHERE;
            }
            return NOWHERE.trace(newView.getTrace()).time(DebuggerCoordinates.resolveTime(newView)).replaceView(newView);
        }
        if (newView.getTrace() != this.trace) {
            throw new IllegalArgumentException("Cannot change trace");
        }
        return this.time(DebuggerCoordinates.resolveTime(newView)).replaceView(newView);
    }

    private static TraceThread resolveThread(Trace trace, KeyPath path) {
        TraceObject object = trace.getObjectManager().getObjectByCanonicalPath(path);
        if (object == null) {
            return null;
        }
        return object.queryCanonicalAncestorsInterface(TraceObjectThread.class).findFirst().orElse(null);
    }

    private static Integer resolveFrame(Trace trace, KeyPath path) {
        TraceObject object = trace.getObjectManager().getObjectByCanonicalPath(path);
        if (object == null) {
            return null;
        }
        TraceObjectStackFrame frame = object.queryCanonicalAncestorsInterface(TraceObjectStackFrame.class).findFirst().orElse(null);
        return frame == null ? null : Integer.valueOf(frame.getLevel());
    }

    public DebuggerCoordinates path(KeyPath newPath) {
        if (this.trace == null && newPath == null) {
            return NOWHERE;
        }
        if (this.trace == null) {
            throw new IllegalArgumentException("No trace");
        }
        if (newPath == null) {
            return new DebuggerCoordinates(this.trace, this.platform, this.target, this.thread, this.view, this.time, this.frame, newPath);
        }
        TraceThread newThread = this.target != null ? DebuggerCoordinates.resolveThread(this.target, newPath) : DebuggerCoordinates.resolveThread(this.trace, newPath);
        Integer newFrame = this.target != null ? DebuggerCoordinates.resolveFrame(this.target, newPath) : DebuggerCoordinates.resolveFrame(this.trace, newPath);
        return new DebuggerCoordinates(this.trace, this.platform, this.target, newThread, this.view, this.time, newFrame, newPath);
    }

    public DebuggerCoordinates pathNonCanonical(KeyPath newPath) {
        if (this.trace == null && newPath == null) {
            return NOWHERE;
        }
        if (this.trace == null) {
            throw new IllegalArgumentException("No trace");
        }
        if (newPath == null) {
            return new DebuggerCoordinates(this.trace, this.platform, this.target, this.thread, this.view, this.time, this.frame, newPath);
        }
        TraceObject object = this.trace.getObjectManager().getObjectByCanonicalPath(newPath);
        if (object != null) {
            return this.path(newPath);
        }
        object = this.trace.getObjectManager().getObjectsByPath(Lifespan.at((long)this.getSnap()), newPath).findAny().orElse(null);
        if (object != null) {
            return this.path(object.getCanonicalPath());
        }
        throw new IllegalArgumentException("No such object at path " + String.valueOf(newPath));
    }

    protected static TraceThread resolveThread(Target target, KeyPath objectPath) {
        return target.getThreadForSuccessor(objectPath);
    }

    protected static Integer resolveFrame(Target target, KeyPath objectPath) {
        TraceStackFrame frame = target.getStackFrameForSuccessor(objectPath);
        return frame == null ? null : Integer.valueOf(frame.getLevel());
    }

    public DebuggerCoordinates object(TraceObject newObject) {
        if (newObject == null) {
            return this.path(null);
        }
        return this.trace(newObject.getTrace()).path(newObject.getCanonicalPath());
    }

    public Trace getTrace() {
        return this.trace;
    }

    public TracePlatform getPlatform() {
        return this.platform;
    }

    public Target getTarget() {
        return this.target;
    }

    public TraceThread getThread() {
        return this.thread;
    }

    public TraceProgramView getView() {
        if (this.trace == null) {
            return this.view;
        }
        return this.view == null ? this.trace.getProgramView() : this.view;
    }

    public long getSnap() {
        return this.getTime().getSnap();
    }

    public TraceSchedule getTime() {
        return this.time == null ? TraceSchedule.ZERO : this.time;
    }

    public int getFrame() {
        return this.frame == null ? 0 : this.frame;
    }

    public KeyPath getPath() {
        return this.path;
    }

    private TraceObject doGetObject() {
        if (this.trace == null) {
            return null;
        }
        return this.trace.getObjectManager().getObjectByCanonicalPath(this.path);
    }

    public synchronized TraceObject getObject() {
        if (this.object == null) {
            this.object = this.doGetObject();
        }
        return this.object;
    }

    public TraceObject getRegisterContainer() {
        if (this.registerContainer != null) {
            return this.registerContainer;
        }
        TraceObject object = this.getObject();
        if (object == null) {
            return null;
        }
        this.registerContainer = object.findRegisterContainer(this.getFrame());
        return this.registerContainer;
    }

    public synchronized long getViewSnap() {
        if (this.viewSnap != null) {
            return this.viewSnap;
        }
        TraceSchedule defaultedTime = this.getTime();
        if (defaultedTime.isSnapOnly()) {
            this.viewSnap = defaultedTime.getSnap();
            return this.viewSnap;
        }
        Collection snapshots = this.trace.getTimeManager().getSnapshotsWithSchedule(defaultedTime);
        if (snapshots.isEmpty()) {
            Msg.warn((Object)this, (Object)"Seems the emulation service did not create the requested snapshot, yet");
            return defaultedTime.getSnap();
        }
        this.viewSnap = ((TraceSnapshot)snapshots.iterator().next()).getKey();
        return this.viewSnap;
    }

    public void writeDataState(PluginTool tool, SaveState saveState, String key) {
        if (this == NOWHERE) {
            return;
        }
        SaveState coordState = new SaveState();
        if (this.trace != null) {
            DomainFile df = this.trace.getDomainFile();
            if (df.getParent() == null) {
                return;
            }
            ProjectLocator projLoc = df.getProjectLocator();
            if (projLoc != null && !projLoc.isTransient()) {
                coordState.putString(KEY_TRACE_PROJ_LOC, projLoc.getLocation());
                coordState.putString(KEY_TRACE_PROJ_NAME, projLoc.getName());
                coordState.putString(KEY_TRACE_PATH, df.getPathname());
                if (!df.isLatestVersion()) {
                    coordState.putInt(KEY_TRACE_VERSION, df.getVersion());
                }
            }
        }
        if (this.thread != null) {
            coordState.putLong(KEY_THREAD_KEY, this.thread.getKey());
        }
        if (this.time != null) {
            coordState.putString(KEY_TIME, this.time.toString(TraceSchedule.TimeRadix.DEC));
        }
        if (this.frame != null) {
            coordState.putInt(KEY_FRAME, this.frame.intValue());
        }
        saveState.putXmlElement(key, coordState.saveToXml());
    }

    protected static DomainFile getDomainFile(PluginTool tool, SaveState coordState) {
        DomainFile df;
        String pathname = coordState.getString(KEY_TRACE_PATH, null);
        String location = coordState.getString(KEY_TRACE_PROJ_LOC, null);
        String projName = coordState.getString(KEY_TRACE_PROJ_NAME, null);
        if (location == null || projName == null) {
            return null;
        }
        ProjectLocator projLoc = new ProjectLocator(location, projName);
        ProjectData projData = tool.getProject().getProjectData(projLoc);
        if (projData == null) {
            try {
                projData = new DefaultProjectData(projLoc, false, false);
            }
            catch (NotOwnerException e) {
                Msg.error(DebuggerCoordinates.class, (Object)("Not project owner: " + String.valueOf(projLoc) + "(" + pathname + ")"));
                return null;
            }
            catch (LockException | IOException e) {
                Msg.error(DebuggerCoordinates.class, (Object)("Project error: " + e.getMessage()));
                return null;
            }
        }
        if ((df = projData.getFile(pathname)) == null || !"Trace".equals(df.getContentType())) {
            String message = "Can't open trace - \"" + pathname + "\"";
            int version = coordState.getInt(KEY_TRACE_VERSION, -1);
            if (version != -1) {
                message = message + " version " + version;
            }
            Msg.error(DebuggerCoordinates.class, (Object)message);
            return null;
        }
        return df;
    }

    public static DebuggerCoordinates readDataState(PluginTool tool, SaveState saveState, String key) {
        TraceSchedule time;
        if (!saveState.hasValue(key)) {
            return NOWHERE;
        }
        DebuggerTraceManagerService traceManager = (DebuggerTraceManagerService)tool.getService(DebuggerTraceManagerService.class);
        Trace trace = null;
        Element coordElement = saveState.getXmlElement(key);
        SaveState coordState = new SaveState(coordElement);
        if (traceManager != null) {
            DomainFile df = DebuggerCoordinates.getDomainFile(tool, coordState);
            int version = coordState.getInt(KEY_TRACE_VERSION, -1);
            if (df != null) {
                trace = traceManager.openTrace(df, version);
            }
        }
        TraceThread thread = null;
        if (trace != null && coordState.hasValue(KEY_THREAD_KEY)) {
            long threadKey = coordState.getLong(KEY_THREAD_KEY, 0L);
            thread = trace.getThreadManager().getThread(threadKey);
        }
        String timeSpec = coordState.getString(KEY_TIME, null);
        try {
            time = TraceSchedule.parse((String)timeSpec, (TraceSchedule.TimeRadix)TraceSchedule.TimeRadix.DEC);
        }
        catch (Exception e) {
            Msg.error(DebuggerCoordinates.class, (Object)("Could not restore invalid time specification: " + timeSpec));
            time = TraceSchedule.ZERO;
        }
        Integer frame = null;
        if (coordState.hasValue(KEY_FRAME)) {
            frame = coordState.getInt(KEY_FRAME, 0);
        }
        TraceObject object = null;
        if (trace != null && coordState.hasValue(KEY_OBJ_PATH)) {
            String pathString = coordState.getString(KEY_OBJ_PATH, "");
            try {
                KeyPath path = KeyPath.parse((String)pathString);
                object = trace.getObjectManager().getObjectByCanonicalPath(path);
            }
            catch (Exception e) {
                Msg.error(DebuggerCoordinates.class, (Object)("Could not restore object: " + pathString), (Throwable)e);
                object = trace.getObjectManager().getRootObject();
            }
        }
        DebuggerCoordinates coords = NOWHERE.trace(trace).thread(thread).time(time).frame(frame).object(object);
        return coords;
    }

    public static boolean isAlive(Target target) {
        return target != null && target.isValid();
    }

    public boolean isAlive() {
        return DebuggerCoordinates.isAlive(this.target);
    }

    public static boolean isAliveAndPresent(TraceProgramView view, Target target) {
        return DebuggerCoordinates.isAlive(target) && target.getSnap() == view.getSnap();
    }

    protected boolean isPresent() {
        TraceSchedule defaultedTime = this.getTime();
        return this.target.getSnap() == defaultedTime.getSnap() && defaultedTime.isSnapOnly();
    }

    protected boolean isReadsPresent() {
        return this.target.getSnap() == this.getTime().getSnap();
    }

    public boolean isAliveAndPresent() {
        return this.isAlive() && this.isPresent();
    }

    public boolean isDeadOrPresent() {
        return !this.isAlive() || this.isPresent();
    }

    public boolean isAliveAndReadsPresent() {
        return this.isAlive() && this.isReadsPresent();
    }
}

