/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.utils;

import ghidra.app.plugin.core.debug.utils.TransactionCoalescer;
import ghidra.async.AsyncDebouncer;
import ghidra.async.AsyncTimer;
import ghidra.framework.model.DomainObject;
import ghidra.util.Msg;

public class DefaultTransactionCoalescer<T extends DomainObject, U extends AutoCloseable>
implements TransactionCoalescer {
    protected final Object lock = new Object();
    protected final T obj;
    protected final TransactionCoalescer.TxFactory<? super T, U> factory;
    protected final int delayMs;
    protected Coalescer tx;

    public DefaultTransactionCoalescer(T obj, TransactionCoalescer.TxFactory<? super T, U> factory, int delayMs) {
        this.obj = obj;
        this.factory = factory;
        this.delayMs = delayMs;
    }

    @Override
    public DefaultCoalescedTx start(String description) {
        return new DefaultCoalescedTx(description);
    }

    public class DefaultCoalescedTx
    implements TransactionCoalescer.CoalescedTx {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected DefaultCoalescedTx(String description) {
            Object object = DefaultTransactionCoalescer.this.lock;
            synchronized (object) {
                if (DefaultTransactionCoalescer.this.tx == null) {
                    DefaultTransactionCoalescer.this.tx = new Coalescer(description);
                }
                DefaultTransactionCoalescer.this.tx.enter();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            Object object = DefaultTransactionCoalescer.this.lock;
            synchronized (object) {
                if (DefaultTransactionCoalescer.this.tx == null) {
                    return;
                }
                DefaultTransactionCoalescer.this.tx.exit();
            }
        }
    }

    protected class Coalescer {
        private final AsyncDebouncer<Void> debouncer;
        private final U tid;
        private volatile int activeCount;

        public Coalescer(String description) {
            this.debouncer = new AsyncDebouncer(AsyncTimer.DEFAULT_TIMER, (long)DefaultTransactionCoalescer.this.delayMs);
            this.activeCount = 0;
            this.tid = (AutoCloseable)DefaultTransactionCoalescer.this.factory.apply(DefaultTransactionCoalescer.this.obj, description);
            this.debouncer.addListener(this::settled);
        }

        private void enter() {
            ++this.activeCount;
        }

        private void exit() {
            if (--this.activeCount == 0) {
                this.debouncer.contact(null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void settled(Void __) {
            Object object = DefaultTransactionCoalescer.this.lock;
            synchronized (object) {
                if (this.activeCount == 0) {
                    try {
                        this.tid.close();
                    }
                    catch (Exception e) {
                        Msg.error((Object)this, (Object)"Could not close transaction: ", (Throwable)e);
                    }
                    DefaultTransactionCoalescer.this.tx = null;
                }
            }
        }
    }
}

