/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.ios.img3.tag;

import ghidra.app.util.bin.BinaryReader;
import ghidra.file.formats.ios.img3.AbstractImg3Tag;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.Structure;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class VersionTag
extends AbstractImg3Tag {
    private int _length;
    private byte[] _versionString;

    VersionTag(BinaryReader reader) throws IOException {
        super(reader);
        this._length = reader.readNextInt();
        this._versionString = reader.readNextByteArray(this._length);
    }

    public int getLength() {
        return this._length;
    }

    public String getVersionString() {
        return new String(this._versionString);
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        Structure structure = (Structure)super.toDataType();
        structure.add(DWORD, "length", null);
        structure.add(STRING, this._length, "version", null);
        return structure;
    }
}

