/*
 * Decompiled with CFR 0.152.
 */
package ghidra.jython;

import generic.jar.ResourceFile;
import ghidra.app.script.GhidraScript;
import ghidra.app.script.GhidraScriptProvider;
import ghidra.app.script.GhidraScriptUtil;
import ghidra.app.script.GhidraState;
import ghidra.app.services.ConsoleService;
import ghidra.framework.plugintool.PluginTool;
import ghidra.jython.GhidraJythonInterpreter;
import ghidra.jython.JythonScriptExecutionThread;
import ghidra.util.exception.AssertException;
import java.io.PrintWriter;
import java.util.concurrent.atomic.AtomicBoolean;

public class JythonScript
extends GhidraScript {
    static final String JYTHON_INTERPRETER = "ghidra.jython.interpreter";
    private AtomicBoolean interpreterRunning = new AtomicBoolean();

    public void run() {
        GhidraJythonInterpreter interpreter = (GhidraJythonInterpreter)((Object)this.state.getEnvironmentVar(JYTHON_INTERPRETER));
        if (interpreter != null) {
            this.runInExistingEnvironment(interpreter);
        } else {
            this.runInNewEnvironment();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runScript(String scriptName, GhidraState scriptState) throws Exception {
        GhidraJythonInterpreter interpreter = (GhidraJythonInterpreter)((Object)this.state.getEnvironmentVar(JYTHON_INTERPRETER));
        if (interpreter == null && (interpreter = GhidraJythonInterpreter.get()) == null) {
            throw new AssertException("Could not get Ghidra Jython interpreter!");
        }
        ResourceFile scriptSource = GhidraScriptUtil.findScriptByName((String)scriptName);
        if (scriptSource != null) {
            GhidraScriptProvider provider = GhidraScriptUtil.getProvider((ResourceFile)scriptSource);
            GhidraScript ghidraScript = provider.getScriptInstance(scriptSource, this.errorWriter);
            if (ghidraScript == null) {
                throw new IllegalArgumentException("Script does not exist: " + scriptName);
            }
            if (scriptState == this.state) {
                this.updateStateFromVariables();
            }
            try {
                interpreter.saveLocals();
                interpreter.clearLocals();
                if (ghidraScript instanceof JythonScript) {
                    ghidraScript.set(scriptState);
                    JythonScript jythonScript = (JythonScript)ghidraScript;
                    interpreter.execFile(jythonScript.getSourceFile(), jythonScript);
                } else {
                    ghidraScript.execute(scriptState, this.getControls());
                }
            }
            finally {
                interpreter.restoreLocals();
            }
            if (scriptState == this.state) {
                this.loadVariablesFromState();
            }
            return;
        }
        throw new IllegalArgumentException("Script does not exist: " + scriptName);
    }

    private void runInExistingEnvironment(GhidraJythonInterpreter interpreter) {
        interpreter.execFile(this.sourceFile, this);
    }

    private void runInNewEnvironment() {
        GhidraJythonInterpreter interpreter = GhidraJythonInterpreter.get();
        PrintWriter stdout = this.getStdOut();
        PrintWriter stderr = this.getStdErr();
        interpreter.setOut(stdout);
        interpreter.setErr(stderr);
        this.state.addEnvironmentVar(JYTHON_INTERPRETER, (Object)interpreter);
        JythonScriptExecutionThread executionThread = new JythonScriptExecutionThread(this, interpreter, this.interpreterRunning);
        this.interpreterRunning.set(true);
        executionThread.start();
        while (this.interpreterRunning.get() && !this.monitor.isCancelled()) {
            Thread.yield();
            this.sleep100millis();
        }
        if (this.interpreterRunning.get()) {
            interpreter.interrupt(executionThread);
        }
        stderr.flush();
        stdout.flush();
        interpreter.cleanup();
        this.state.removeEnvironmentVar(JYTHON_INTERPRETER);
    }

    private PrintWriter getStdOut() {
        ConsoleService console;
        PluginTool tool = this.state.getTool();
        if (tool != null && (console = (ConsoleService)tool.getService(ConsoleService.class)) != null) {
            return console.getStdOut();
        }
        return new PrintWriter(System.out, true);
    }

    private PrintWriter getStdErr() {
        ConsoleService console;
        PluginTool tool = this.state.getTool();
        if (tool != null && (console = (ConsoleService)tool.getService(ConsoleService.class)) != null) {
            return console.getStdErr();
        }
        return new PrintWriter(System.err, true);
    }

    private void sleep100millis() {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public String getCategory() {
        return "Jython";
    }
}

