/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.coverage.org.objectweb.asm.util;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.coverage.org.objectweb.asm.Attribute;
import org.jetbrains.coverage.org.objectweb.asm.Handle;
import org.jetbrains.coverage.org.objectweb.asm.Label;
import org.jetbrains.coverage.org.objectweb.asm.Type;
import org.jetbrains.coverage.org.objectweb.asm.TypePath;
import org.jetbrains.coverage.org.objectweb.asm.TypeReference;
import org.jetbrains.coverage.org.objectweb.asm.signature.SignatureReader;
import org.jetbrains.coverage.org.objectweb.asm.util.Printer;
import org.jetbrains.coverage.org.objectweb.asm.util.TextifierSupport;
import org.jetbrains.coverage.org.objectweb.asm.util.TraceSignatureVisitor;

public class Textifier
extends Printer {
    public static final int INTERNAL_NAME = 0;
    public static final int FIELD_DESCRIPTOR = 1;
    public static final int FIELD_SIGNATURE = 2;
    public static final int METHOD_DESCRIPTOR = 3;
    public static final int METHOD_SIGNATURE = 4;
    public static final int CLASS_SIGNATURE = 5;
    public static final int HANDLE_DESCRIPTOR = 9;
    private static final List<String> FRAME_TYPES = Collections.unmodifiableList(Arrays.asList("T", "I", "F", "D", "J", "N", "U"));
    protected String tab = "  ";
    protected String tab2 = "    ";
    protected String tab3 = "      ";
    protected String ltab = "   ";
    protected Map<Label, String> labelNames;
    private int access;
    private int numAnnotationValues;

    public Textifier() {
        this(589824);
        if (this.getClass() != Textifier.class) {
            throw new IllegalStateException();
        }
    }

    /*
     * WARNING - void declaration
     */
    protected Textifier(int api) {
        super((int)var1_1);
        void var1_1;
    }

    public static void main(String[] args) throws IOException {
        Textifier.main(args, new PrintWriter(System.out, true), new PrintWriter(System.err, true));
    }

    /*
     * WARNING - void declaration
     */
    static void main(String[] args, PrintWriter output, PrintWriter logger) throws IOException {
        void var2_2;
        void var1_1;
        Textifier.main(args, "Prints a disassembled view of the given class.\nUsage: Textifier [-nodebug] <fully qualified class name or class file name>", new Textifier(), (PrintWriter)var1_1, (PrintWriter)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        void var3_3;
        void var2_2;
        if ((access & 0x8000) != 0) {
            return;
        }
        this.access = access;
        int majorVersion = version & 0xFFFF;
        int minorVersion = version >>> 16;
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("// class version ").append(majorVersion).append('.').append(minorVersion).append(" (").append(version).append(")\n");
        if ((access & 0x20000) != 0) {
            this.stringBuilder.append("// DEPRECATED\n");
        }
        if ((access & 0x10000) != 0) {
            this.stringBuilder.append("// RECORD\n");
        }
        this.appendRawAccess(access);
        this.appendDescriptor(5, signature);
        if (signature != null) {
            this.appendJavaDeclaration(name, signature);
        }
        this.appendAccess(access & 0xFFFF7FDF);
        if ((access & 0x2000) != 0) {
            this.stringBuilder.append("@interface ");
        } else if ((access & 0x200) != 0) {
            this.stringBuilder.append("interface ");
        } else if ((var2_2 & 0x4000) == 0) {
            this.stringBuilder.append("class ");
        }
        this.appendDescriptor(0, (String)var3_3);
        if (superName != null && !"java/lang/Object".equals(superName)) {
            this.stringBuilder.append(" extends ");
            this.appendDescriptor(0, superName);
        }
        if (interfaces != null && interfaces.length > 0) {
            this.stringBuilder.append(" implements ");
            for (int i = 0; i < interfaces.length; ++i) {
                this.appendDescriptor(0, interfaces[i]);
                if (i == interfaces.length - 1) continue;
                this.stringBuilder.append(' ');
            }
        }
        this.stringBuilder.append(" {\n\n");
        this.text.add(this.stringBuilder.toString());
    }

    /*
     * WARNING - void declaration
     */
    public void visitSource(String file, String debug) {
        this.stringBuilder.setLength(0);
        if (file != null) {
            void var1_1;
            this.stringBuilder.append(this.tab).append("// compiled from: ").append((String)var1_1).append('\n');
        }
        if (debug != null) {
            void var2_2;
            this.stringBuilder.append(this.tab).append("// debug info: ").append((String)var2_2).append('\n');
        }
        if (this.stringBuilder.length() > 0) {
            this.text.add(this.stringBuilder.toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    public Printer visitModule(String name, int access, String version) {
        void var3_3;
        void var1_1;
        void var2_2;
        this.stringBuilder.setLength(0);
        if ((var2_2 & 0x20) != 0) {
            this.stringBuilder.append("open ");
        }
        this.stringBuilder.append("module ").append((String)var1_1).append(" { ").append(version == null ? "" : "// " + (String)var3_3).append("\n\n");
        this.text.add(this.stringBuilder.toString());
        return this.addNewTextifier(null);
    }

    /*
     * WARNING - void declaration
     */
    public void visitNestHost(String nestHost) {
        void var1_1;
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.tab).append("NESTHOST ");
        this.appendDescriptor(0, (String)var1_1);
        this.stringBuilder.append('\n');
        this.text.add(this.stringBuilder.toString());
    }

    /*
     * WARNING - void declaration
     */
    public void visitOuterClass(String owner, String name, String descriptor) {
        void var3_3;
        void var1_1;
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.tab).append("OUTERCLASS ");
        this.appendDescriptor(0, (String)var1_1);
        this.stringBuilder.append(' ');
        if (name != null) {
            void var2_2;
            this.stringBuilder.append((String)var2_2).append(' ');
        }
        this.appendDescriptor(3, (String)var3_3);
        this.stringBuilder.append('\n');
        this.text.add(this.stringBuilder.toString());
    }

    /*
     * WARNING - void declaration
     */
    public Textifier visitClassAnnotation(String descriptor, boolean visible) {
        void var2_2;
        void var1_1;
        this.text.add("\n");
        return this.visitAnnotation((String)var1_1, (boolean)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public Printer visitClassTypeAnnotation(int typeRef, TypePath typePath, String descriptor, boolean visible) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.text.add("\n");
        return this.visitTypeAnnotation((int)var1_1, (TypePath)var2_2, (String)var3_3, visible);
    }

    /*
     * WARNING - void declaration
     */
    public void visitClassAttribute(Attribute attribute) {
        void var1_1;
        this.text.add("\n");
        this.visitAttribute((Attribute)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void visitNestMember(String nestMember) {
        void var1_1;
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.tab).append("NESTMEMBER ");
        this.appendDescriptor(0, (String)var1_1);
        this.stringBuilder.append('\n');
        this.text.add(this.stringBuilder.toString());
    }

    /*
     * WARNING - void declaration
     */
    public void visitPermittedSubclass(String permittedSubclass) {
        void var1_1;
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.tab).append("PERMITTEDSUBCLASS ");
        this.appendDescriptor(0, (String)var1_1);
        this.stringBuilder.append('\n');
        this.text.add(this.stringBuilder.toString());
    }

    /*
     * WARNING - void declaration
     */
    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.tab);
        this.appendRawAccess(access & 0xFFFFFFDF);
        this.stringBuilder.append(this.tab);
        this.appendAccess(access);
        this.stringBuilder.append("INNERCLASS ");
        this.appendDescriptor(0, (String)var1_1);
        this.stringBuilder.append(' ');
        this.appendDescriptor(0, (String)var2_2);
        this.stringBuilder.append(' ');
        this.appendDescriptor(0, (String)var3_3);
        this.stringBuilder.append('\n');
        this.text.add(this.stringBuilder.toString());
    }

    /*
     * WARNING - void declaration
     */
    public Printer visitRecordComponent(String name, String descriptor, String signature) {
        void var1_1;
        void var2_2;
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.tab).append("RECORDCOMPONENT ");
        if (signature != null) {
            void var3_3;
            this.stringBuilder.append(this.tab);
            this.appendDescriptor(2, signature);
            this.stringBuilder.append(this.tab);
            this.appendJavaDeclaration(name, (String)var3_3);
        }
        this.stringBuilder.append(this.tab);
        this.appendDescriptor(1, (String)var2_2);
        this.stringBuilder.append(' ').append((String)var1_1);
        this.stringBuilder.append('\n');
        this.text.add(this.stringBuilder.toString());
        return this.addNewTextifier(null);
    }

    /*
     * WARNING - void declaration
     */
    public Textifier visitField(int access, String name, String descriptor, String signature, Object value) {
        void var2_2;
        void var3_3;
        void var1_1;
        this.stringBuilder.setLength(0);
        this.stringBuilder.append('\n');
        if ((access & 0x20000) != 0) {
            this.stringBuilder.append(this.tab).append("// DEPRECATED\n");
        }
        this.stringBuilder.append(this.tab);
        this.appendRawAccess(access);
        if (signature != null) {
            this.stringBuilder.append(this.tab);
            this.appendDescriptor(2, signature);
            this.stringBuilder.append(this.tab);
            this.appendJavaDeclaration(name, signature);
        }
        this.stringBuilder.append(this.tab);
        this.appendAccess((int)var1_1);
        this.appendDescriptor(1, (String)var3_3);
        this.stringBuilder.append(' ').append((String)var2_2);
        if (value != null) {
            this.stringBuilder.append(" = ");
            if (value instanceof String) {
                this.stringBuilder.append('\"').append(value).append('\"');
            } else {
                this.stringBuilder.append(value);
            }
        }
        this.stringBuilder.append('\n');
        this.text.add(this.stringBuilder.toString());
        return this.addNewTextifier(null);
    }

    /*
     * WARNING - void declaration
     */
    public Textifier visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
        void var3_5;
        void var2_3;
        void var1_1;
        this.stringBuilder.setLength(0);
        this.stringBuilder.append('\n');
        if ((access & 0x20000) != 0) {
            this.stringBuilder.append(this.tab).append("// DEPRECATED\n");
        }
        this.stringBuilder.append(this.tab);
        this.appendRawAccess(access);
        if (signature != null) {
            this.stringBuilder.append(this.tab);
            this.appendDescriptor(4, signature);
            this.stringBuilder.append(this.tab);
            this.appendJavaDeclaration(name, signature);
        }
        this.stringBuilder.append(this.tab);
        this.appendAccess(access & 0xFFFFFF3F);
        if ((access & 0x100) != 0) {
            this.stringBuilder.append("native ");
        }
        if ((access & 0x80) != 0) {
            this.stringBuilder.append("varargs ");
        }
        if ((access & 0x40) != 0) {
            this.stringBuilder.append("bridge ");
        }
        if ((this.access & 0x200) != 0 && (var1_1 & 0x408) == 0) {
            this.stringBuilder.append("default ");
        }
        this.stringBuilder.append((String)var2_3);
        this.appendDescriptor(3, (String)var3_5);
        if (exceptions != null && exceptions.length > 0) {
            this.stringBuilder.append(" throws ");
            String[] stringArray = exceptions;
            int n = exceptions.length;
            for (int i = 0; i < n; ++i) {
                String exception = stringArray[i];
                this.appendDescriptor(0, exception);
                this.stringBuilder.append(' ');
            }
        }
        this.stringBuilder.append('\n');
        this.text.add(this.stringBuilder.toString());
        return this.addNewTextifier(null);
    }

    public void visitClassEnd() {
        this.text.add("}\n");
    }

    /*
     * WARNING - void declaration
     */
    public void visitMainClass(String mainClass) {
        void var1_1;
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("  // main class ").append((String)var1_1).append('\n');
        this.text.add(this.stringBuilder.toString());
    }

    /*
     * WARNING - void declaration
     */
    public void visitPackage(String packaze) {
        void var1_1;
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("  // package ").append((String)var1_1).append('\n');
        this.text.add(this.stringBuilder.toString());
    }

    /*
     * WARNING - void declaration
     */
    public void visitRequire(String require, int access, String version) {
        void var2_2;
        void var1_1;
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.tab).append("requires ");
        if ((access & 0x20) != 0) {
            this.stringBuilder.append("transitive ");
        }
        if ((access & 0x40) != 0) {
            this.stringBuilder.append("static ");
        }
        this.stringBuilder.append((String)var1_1).append(';');
        this.appendRawAccess((int)var2_2);
        if (version != null) {
            void var3_3;
            this.stringBuilder.append("  // version ").append((String)var3_3).append('\n');
        }
        this.text.add(this.stringBuilder.toString());
    }

    /*
     * WARNING - void declaration
     */
    public void visitExport(String packaze, int access, String ... modules) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.visitExportOrOpen("exports ", (String)var1_1, (int)var2_2, (String[])var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public void visitOpen(String packaze, int access, String ... modules) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.visitExportOrOpen("opens ", (String)var1_1, (int)var2_2, (String[])var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private void visitExportOrOpen(String method, String packaze, int access, String ... modules) {
        void var3_4;
        void var2_3;
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.tab).append(method);
        this.stringBuilder.append((String)var2_3);
        if (modules != null && modules.length > 0) {
            this.stringBuilder.append(" to");
        } else {
            this.stringBuilder.append(';');
        }
        this.appendRawAccess((int)var3_4);
        if (modules != null && modules.length > 0) {
            for (int i = 0; i < modules.length; ++i) {
                this.stringBuilder.append(this.tab2).append(modules[i]);
                this.stringBuilder.append(i != modules.length - 1 ? ",\n" : ";\n");
            }
        }
        this.text.add(this.stringBuilder.toString());
    }

    /*
     * WARNING - void declaration
     */
    public void visitUse(String use) {
        void var1_1;
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.tab).append("uses ");
        this.appendDescriptor(0, (String)var1_1);
        this.stringBuilder.append(";\n");
        this.text.add(this.stringBuilder.toString());
    }

    public void visitProvide(String provide, String ... providers) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.tab).append("provides ");
        this.appendDescriptor(0, provide);
        this.stringBuilder.append(" with\n");
        for (int i = 0; i < providers.length; ++i) {
            this.stringBuilder.append(this.tab2);
            this.appendDescriptor(0, providers[i]);
            this.stringBuilder.append(i != providers.length - 1 ? ",\n" : ";\n");
        }
        this.text.add(this.stringBuilder.toString());
    }

    public void visitModuleEnd() {
    }

    /*
     * WARNING - void declaration
     */
    public void visit(String name, Object value) {
        this.visitAnnotationValue(name);
        if (value instanceof String) {
            this.visitString((String)value);
        } else if (value instanceof Type) {
            this.visitType((Type)value);
        } else if (value instanceof Byte) {
            this.visitByte((Byte)value);
        } else if (value instanceof Boolean) {
            this.visitBoolean((Boolean)value);
        } else if (value instanceof Short) {
            this.visitShort((Short)value);
        } else if (value instanceof Character) {
            this.visitChar(((Character)value).charValue());
        } else if (value instanceof Integer) {
            this.visitInt((Integer)value);
        } else if (value instanceof Float) {
            this.visitFloat(((Float)value).floatValue());
        } else if (value instanceof Long) {
            this.visitLong((Long)value);
        } else if (value instanceof Double) {
            this.visitDouble((Double)value);
        } else if (value.getClass().isArray()) {
            void i2;
            this.stringBuilder.append('{');
            if (value instanceof byte[]) {
                byte[] byteArray = (byte[])value;
                for (int i2 = 0; i2 < byteArray.length; ++i2) {
                    this.maybeAppendComma(i2);
                    this.visitByte(byteArray[i2]);
                }
            } else if (i2 instanceof boolean[]) {
                boolean[] booleanArray = (boolean[])i2;
                for (int i3 = 0; i3 < booleanArray.length; ++i3) {
                    this.maybeAppendComma(i3);
                    this.visitBoolean(booleanArray[i3]);
                }
            } else if (i2 instanceof short[]) {
                short[] shortArray = (short[])i2;
                for (int i4 = 0; i4 < shortArray.length; ++i4) {
                    this.maybeAppendComma(i4);
                    this.visitShort(shortArray[i4]);
                }
            } else if (i2 instanceof char[]) {
                char[] charArray = (char[])i2;
                for (int i5 = 0; i5 < charArray.length; ++i5) {
                    this.maybeAppendComma(i5);
                    this.visitChar(charArray[i5]);
                }
            } else if (i2 instanceof int[]) {
                int[] intArray = (int[])i2;
                for (int i6 = 0; i6 < intArray.length; ++i6) {
                    this.maybeAppendComma(i6);
                    this.visitInt(intArray[i6]);
                }
            } else if (i2 instanceof long[]) {
                long[] longArray = (long[])i2;
                for (int i7 = 0; i7 < longArray.length; ++i7) {
                    this.maybeAppendComma(i7);
                    this.visitLong(longArray[i7]);
                }
            } else if (i2 instanceof float[]) {
                float[] floatArray = (float[])i2;
                for (int i8 = 0; i8 < floatArray.length; ++i8) {
                    this.maybeAppendComma(i8);
                    this.visitFloat(floatArray[i8]);
                }
            } else if (i2 instanceof double[]) {
                double[] doubleArray = (double[])i2;
                for (int i9 = 0; i9 < doubleArray.length; ++i9) {
                    this.maybeAppendComma(i9);
                    this.visitDouble(doubleArray[i9]);
                }
            }
            this.stringBuilder.append('}');
        }
        this.text.add(this.stringBuilder.toString());
    }

    /*
     * WARNING - void declaration
     */
    private void visitInt(int value) {
        void var1_1;
        this.stringBuilder.append((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void visitLong(long value) {
        void var1_1;
        this.stringBuilder.append((long)var1_1).append('L');
    }

    /*
     * WARNING - void declaration
     */
    private void visitFloat(float value) {
        void var1_1;
        this.stringBuilder.append((float)var1_1).append('F');
    }

    /*
     * WARNING - void declaration
     */
    private void visitDouble(double value) {
        void var1_1;
        this.stringBuilder.append((double)var1_1).append('D');
    }

    /*
     * WARNING - void declaration
     */
    private void visitChar(char value) {
        void var1_1;
        this.stringBuilder.append("(char)").append((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void visitShort(short value) {
        void var1_1;
        this.stringBuilder.append("(short)").append((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void visitByte(byte value) {
        void var1_1;
        this.stringBuilder.append("(byte)").append((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void visitBoolean(boolean value) {
        void var1_1;
        this.stringBuilder.append((boolean)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void visitString(String value) {
        void var1_1;
        Textifier.appendString(this.stringBuilder, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void visitType(Type value) {
        void var1_1;
        this.stringBuilder.append(var1_1.getClassName()).append(".class");
    }

    /*
     * WARNING - void declaration
     */
    public void visitEnum(String name, String descriptor, String value) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.visitAnnotationValue((String)var1_1);
        this.appendDescriptor(1, (String)var2_2);
        this.stringBuilder.append('.').append((String)var3_3);
        this.text.add(this.stringBuilder.toString());
    }

    /*
     * WARNING - void declaration
     */
    public Textifier visitAnnotation(String name, String descriptor) {
        void var2_2;
        void var1_1;
        this.visitAnnotationValue((String)var1_1);
        this.stringBuilder.append('@');
        this.appendDescriptor(1, (String)var2_2);
        this.stringBuilder.append('(');
        this.text.add(this.stringBuilder.toString());
        return this.addNewTextifier(")");
    }

    /*
     * WARNING - void declaration
     */
    public Textifier visitArray(String name) {
        void var1_1;
        this.visitAnnotationValue((String)var1_1);
        this.stringBuilder.append('{');
        this.text.add(this.stringBuilder.toString());
        return this.addNewTextifier("}");
    }

    public void visitAnnotationEnd() {
    }

    /*
     * WARNING - void declaration
     */
    private void visitAnnotationValue(String name) {
        this.stringBuilder.setLength(0);
        Textifier textifier = this;
        textifier.maybeAppendComma(textifier.numAnnotationValues++);
        if (name != null) {
            void var1_1;
            this.stringBuilder.append((String)var1_1).append('=');
        }
    }

    /*
     * WARNING - void declaration
     */
    public Textifier visitRecordComponentAnnotation(String descriptor, boolean visible) {
        void var2_2;
        void var1_1;
        return this.visitAnnotation((String)var1_1, (boolean)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public Printer visitRecordComponentTypeAnnotation(int typeRef, TypePath typePath, String descriptor, boolean visible) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.visitTypeAnnotation((int)var1_1, (TypePath)var2_2, (String)var3_3, visible);
    }

    /*
     * WARNING - void declaration
     */
    public void visitRecordComponentAttribute(Attribute attribute) {
        void var1_1;
        this.visitAttribute((Attribute)var1_1);
    }

    public void visitRecordComponentEnd() {
    }

    /*
     * WARNING - void declaration
     */
    public Textifier visitFieldAnnotation(String descriptor, boolean visible) {
        void var2_2;
        void var1_1;
        return this.visitAnnotation((String)var1_1, (boolean)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public Printer visitFieldTypeAnnotation(int typeRef, TypePath typePath, String descriptor, boolean visible) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.visitTypeAnnotation((int)var1_1, (TypePath)var2_2, (String)var3_3, visible);
    }

    /*
     * WARNING - void declaration
     */
    public void visitFieldAttribute(Attribute attribute) {
        void var1_1;
        this.visitAttribute((Attribute)var1_1);
    }

    public void visitFieldEnd() {
    }

    /*
     * WARNING - void declaration
     */
    public void visitParameter(String name, int access) {
        void var1_1;
        void var2_2;
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.tab2).append("// parameter ");
        this.appendAccess((int)var2_2);
        this.stringBuilder.append(' ').append((String)(name == null ? "<no name>" : var1_1)).append('\n');
        this.text.add(this.stringBuilder.toString());
    }

    public Textifier visitAnnotationDefault() {
        this.text.add(this.tab2 + "default=");
        return this.addNewTextifier("\n");
    }

    /*
     * WARNING - void declaration
     */
    public Textifier visitMethodAnnotation(String descriptor, boolean visible) {
        void var2_2;
        void var1_1;
        return this.visitAnnotation((String)var1_1, (boolean)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public Printer visitMethodTypeAnnotation(int typeRef, TypePath typePath, String descriptor, boolean visible) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.visitTypeAnnotation((int)var1_1, (TypePath)var2_2, (String)var3_3, visible);
    }

    /*
     * WARNING - void declaration
     */
    public Textifier visitAnnotableParameterCount(int parameterCount, boolean visible) {
        void var2_2;
        void var1_1;
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.tab2).append("// annotable parameter count: ");
        this.stringBuilder.append((int)var1_1);
        this.stringBuilder.append(var2_2 != false ? " (visible)\n" : " (invisible)\n");
        this.text.add(this.stringBuilder.toString());
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public Textifier visitParameterAnnotation(int parameter, String descriptor, boolean visible) {
        void var1_1;
        void var3_3;
        void var2_2;
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.tab2).append('@');
        this.appendDescriptor(1, (String)var2_2);
        this.stringBuilder.append('(');
        this.text.add(this.stringBuilder.toString());
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(var3_3 != false ? ") // parameter " : ") // invisible, parameter ").append((int)var1_1).append('\n');
        Textifier textifier = this;
        return textifier.addNewTextifier(textifier.stringBuilder.toString());
    }

    /*
     * WARNING - void declaration
     */
    public void visitMethodAttribute(Attribute attribute) {
        void var1_1;
        this.visitAttribute((Attribute)var1_1);
    }

    public void visitCode() {
    }

    /*
     * WARNING - void declaration
     */
    public void visitFrame(int type, int numLocal, Object[] local, int numStack, Object[] stack) {
        void var1_1;
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.ltab);
        this.stringBuilder.append("FRAME ");
        switch (var1_1) {
            case -1: 
            case 0: {
                this.stringBuilder.append("FULL [");
                this.appendFrameTypes(numLocal, local);
                this.stringBuilder.append("] [");
                this.appendFrameTypes(numStack, stack);
                this.stringBuilder.append(']');
                break;
            }
            case 1: {
                void var3_3;
                this.stringBuilder.append("APPEND [");
                this.appendFrameTypes(numLocal, (Object[])var3_3);
                this.stringBuilder.append(']');
                break;
            }
            case 2: {
                void var2_2;
                this.stringBuilder.append("CHOP ").append((int)var2_2);
                break;
            }
            case 3: {
                this.stringBuilder.append("SAME");
                break;
            }
            case 4: {
                this.stringBuilder.append("SAME1 ");
                this.appendFrameTypes(1, stack);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.stringBuilder.append('\n');
        this.text.add(this.stringBuilder.toString());
    }

    /*
     * WARNING - void declaration
     */
    public void visitInsn(int opcode) {
        void var1_1;
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.tab2).append(OPCODES[var1_1]).append('\n');
        this.text.add(this.stringBuilder.toString());
    }

    /*
     * WARNING - void declaration
     */
    public void visitIntInsn(int opcode, int operand) {
        void var2_2;
        void var1_1;
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.tab2).append(OPCODES[opcode]).append(' ').append(var1_1 == 188 ? TYPES[operand] : Integer.toString((int)var2_2)).append('\n');
        this.text.add(this.stringBuilder.toString());
    }

    /*
     * WARNING - void declaration
     */
    public void visitVarInsn(int opcode, int varIndex) {
        void var2_2;
        void var1_1;
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.tab2).append(OPCODES[var1_1]).append(' ').append((int)var2_2).append('\n');
        this.text.add(this.stringBuilder.toString());
    }

    /*
     * WARNING - void declaration
     */
    public void visitTypeInsn(int opcode, String type) {
        void var2_2;
        void var1_1;
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.tab2).append(OPCODES[var1_1]).append(' ');
        this.appendDescriptor(0, (String)var2_2);
        this.stringBuilder.append('\n');
        this.text.add(this.stringBuilder.toString());
    }

    /*
     * WARNING - void declaration
     */
    public void visitFieldInsn(int opcode, String owner, String name, String descriptor) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.tab2).append(OPCODES[var1_1]).append(' ');
        this.appendDescriptor(0, (String)var2_2);
        this.stringBuilder.append('.').append((String)var3_3).append(" : ");
        this.appendDescriptor(1, descriptor);
        this.stringBuilder.append('\n');
        this.text.add(this.stringBuilder.toString());
    }

    /*
     * WARNING - void declaration
     */
    public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean isInterface) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.tab2).append(OPCODES[var1_1]).append(' ');
        this.appendDescriptor(0, (String)var2_2);
        this.stringBuilder.append('.').append((String)var3_3).append(' ');
        this.appendDescriptor(3, descriptor);
        if (isInterface) {
            this.stringBuilder.append(" (itf)");
        }
        this.stringBuilder.append('\n');
        this.text.add(this.stringBuilder.toString());
    }

    /*
     * WARNING - void declaration
     */
    public void visitInvokeDynamicInsn(String name, String descriptor, Handle bootstrapMethodHandle, Object ... bootstrapMethodArguments) {
        void var3_4;
        void var2_2;
        Object[] objectArray;
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.tab2).append("INVOKEDYNAMIC ");
        this.stringBuilder.append((String)objectArray);
        this.appendDescriptor(3, (String)var2_2);
        this.stringBuilder.append(" [");
        this.stringBuilder.append('\n');
        this.stringBuilder.append(this.tab3);
        this.appendHandle((Handle)var3_4);
        this.stringBuilder.append('\n');
        this.stringBuilder.append(this.tab3).append("// arguments:");
        if (bootstrapMethodArguments.length == 0) {
            this.stringBuilder.append(" none");
        } else {
            this.stringBuilder.append('\n');
            objectArray = bootstrapMethodArguments;
            int n = bootstrapMethodArguments.length;
            for (int i = 0; i < n; ++i) {
                void var4_6;
                Object value = objectArray[i];
                this.stringBuilder.append(this.tab3);
                if (value instanceof String) {
                    Printer.appendString(this.stringBuilder, (String)value);
                } else if (value instanceof Type) {
                    Type type = (Type)value;
                    if (type.getSort() == 11) {
                        this.appendDescriptor(3, type.getDescriptor());
                    } else {
                        this.visitType(type);
                    }
                } else if (var4_6 instanceof Handle) {
                    this.appendHandle((Handle)var4_6);
                } else {
                    this.stringBuilder.append(var4_6);
                }
                this.stringBuilder.append(", \n");
            }
            this.stringBuilder.setLength(this.stringBuilder.length() - 3);
        }
        this.stringBuilder.append('\n');
        this.stringBuilder.append(this.tab2).append("]\n");
        this.text.add(this.stringBuilder.toString());
    }

    /*
     * WARNING - void declaration
     */
    public void visitJumpInsn(int opcode, Label label) {
        void var2_2;
        void var1_1;
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.tab2).append(OPCODES[var1_1]).append(' ');
        this.appendLabel((Label)var2_2);
        this.stringBuilder.append('\n');
        this.text.add(this.stringBuilder.toString());
    }

    /*
     * WARNING - void declaration
     */
    public void visitLabel(Label label) {
        void var1_1;
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.ltab);
        this.appendLabel((Label)var1_1);
        this.stringBuilder.append('\n');
        this.text.add(this.stringBuilder.toString());
    }

    /*
     * WARNING - void declaration
     */
    public void visitLdcInsn(Object value) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.tab2).append("LDC ");
        if (value instanceof String) {
            Printer.appendString(this.stringBuilder, (String)value);
        } else if (value instanceof Type) {
            this.stringBuilder.append(((Type)value).getDescriptor()).append(".class");
        } else {
            void var1_1;
            this.stringBuilder.append(var1_1);
        }
        this.stringBuilder.append('\n');
        this.text.add(this.stringBuilder.toString());
    }

    /*
     * WARNING - void declaration
     */
    public void visitIincInsn(int varIndex, int increment) {
        void var2_2;
        void var1_1;
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.tab2).append("IINC ").append((int)var1_1).append(' ').append((int)var2_2).append('\n');
        this.text.add(this.stringBuilder.toString());
    }

    /*
     * WARNING - void declaration
     */
    public void visitTableSwitchInsn(int min, int max, Label dflt, Label ... labels) {
        void var3_3;
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.tab2).append("TABLESWITCH\n");
        for (int i = 0; i < labels.length; ++i) {
            this.stringBuilder.append(this.tab3).append(min + i).append(": ");
            this.appendLabel(labels[i]);
            this.stringBuilder.append('\n');
        }
        this.stringBuilder.append(this.tab3).append("default: ");
        this.appendLabel((Label)var3_3);
        this.stringBuilder.append('\n');
        this.text.add(this.stringBuilder.toString());
    }

    /*
     * WARNING - void declaration
     */
    public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        void var1_1;
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.tab2).append("LOOKUPSWITCH\n");
        for (int i = 0; i < labels.length; ++i) {
            this.stringBuilder.append(this.tab3).append(keys[i]).append(": ");
            this.appendLabel(labels[i]);
            this.stringBuilder.append('\n');
        }
        this.stringBuilder.append(this.tab3).append("default: ");
        this.appendLabel((Label)var1_1);
        this.stringBuilder.append('\n');
        this.text.add(this.stringBuilder.toString());
    }

    /*
     * WARNING - void declaration
     */
    public void visitMultiANewArrayInsn(String descriptor, int numDimensions) {
        void var2_2;
        void var1_1;
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.tab2).append("MULTIANEWARRAY ");
        this.appendDescriptor(1, (String)var1_1);
        this.stringBuilder.append(' ').append((int)var2_2).append('\n');
        this.text.add(this.stringBuilder.toString());
    }

    /*
     * WARNING - void declaration
     */
    public Printer visitInsnAnnotation(int typeRef, TypePath typePath, String descriptor, boolean visible) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.visitTypeAnnotation((int)var1_1, (TypePath)var2_2, (String)var3_3, visible);
    }

    /*
     * WARNING - void declaration
     */
    public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.tab2).append("TRYCATCHBLOCK ");
        this.appendLabel((Label)var1_1);
        this.stringBuilder.append(' ');
        this.appendLabel((Label)var2_2);
        this.stringBuilder.append(' ');
        this.appendLabel((Label)var3_3);
        this.stringBuilder.append(' ');
        this.appendDescriptor(0, type);
        this.stringBuilder.append('\n');
        this.text.add(this.stringBuilder.toString());
    }

    /*
     * WARNING - void declaration
     */
    public Printer visitTryCatchAnnotation(int typeRef, TypePath typePath, String descriptor, boolean visible) {
        void var2_2;
        void var1_1;
        void var3_3;
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.tab2).append("TRYCATCHBLOCK @");
        this.appendDescriptor(1, (String)var3_3);
        this.stringBuilder.append('(');
        this.text.add(this.stringBuilder.toString());
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(") : ");
        this.appendTypeReference((int)var1_1);
        this.stringBuilder.append(", ").append(var2_2);
        this.stringBuilder.append(visible ? "\n" : " // invisible\n");
        Textifier textifier = this;
        return textifier.addNewTextifier(textifier.stringBuilder.toString());
    }

    /*
     * WARNING - void declaration
     */
    public void visitLocalVariable(String name, String descriptor, String signature, Label start, Label end, int index) {
        void var2_2;
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.tab2).append("LOCALVARIABLE ").append(name).append(' ');
        this.appendDescriptor(1, (String)var2_2);
        this.stringBuilder.append(' ');
        this.appendLabel(start);
        this.stringBuilder.append(' ');
        this.appendLabel(end);
        this.stringBuilder.append(' ').append(index).append('\n');
        if (signature != null) {
            void var3_3;
            void var1_1;
            this.stringBuilder.append(this.tab2);
            this.appendDescriptor(2, signature);
            this.stringBuilder.append(this.tab2);
            this.appendJavaDeclaration((String)var1_1, (String)var3_3);
        }
        this.text.add(this.stringBuilder.toString());
    }

    /*
     * WARNING - void declaration
     */
    public Printer visitLocalVariableAnnotation(int typeRef, TypePath typePath, Label[] start, Label[] end, int[] index, String descriptor, boolean visible) {
        void var2_2;
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.tab2).append("LOCALVARIABLE @");
        this.appendDescriptor(1, descriptor);
        this.stringBuilder.append('(');
        this.text.add(this.stringBuilder.toString());
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(") : ");
        this.appendTypeReference(typeRef);
        this.stringBuilder.append(", ").append(var2_2);
        for (int i = 0; i < start.length; ++i) {
            this.stringBuilder.append(" [ ");
            this.appendLabel(start[i]);
            this.stringBuilder.append(" - ");
            this.appendLabel(end[i]);
            this.stringBuilder.append(" - ").append(index[i]).append(" ]");
        }
        this.stringBuilder.append(visible ? "\n" : " // invisible\n");
        Textifier textifier = this;
        return textifier.addNewTextifier(textifier.stringBuilder.toString());
    }

    /*
     * WARNING - void declaration
     */
    public void visitLineNumber(int line, Label start) {
        void var2_2;
        void var1_1;
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.tab2).append("LINENUMBER ").append((int)var1_1).append(' ');
        this.appendLabel((Label)var2_2);
        this.stringBuilder.append('\n');
        this.text.add(this.stringBuilder.toString());
    }

    /*
     * WARNING - void declaration
     */
    public void visitMaxs(int maxStack, int maxLocals) {
        void var2_2;
        void var1_1;
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.tab2).append("MAXSTACK = ").append((int)var1_1).append('\n');
        this.text.add(this.stringBuilder.toString());
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.tab2).append("MAXLOCALS = ").append((int)var2_2).append('\n');
        this.text.add(this.stringBuilder.toString());
    }

    public void visitMethodEnd() {
    }

    /*
     * WARNING - void declaration
     */
    public Textifier visitAnnotation(String descriptor, boolean visible) {
        void var2_2;
        void var1_1;
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.tab).append('@');
        this.appendDescriptor(1, (String)var1_1);
        this.stringBuilder.append('(');
        this.text.add(this.stringBuilder.toString());
        return this.addNewTextifier(var2_2 != false ? ")\n" : ") // invisible\n");
    }

    /*
     * WARNING - void declaration
     */
    public Textifier visitTypeAnnotation(int typeRef, TypePath typePath, String descriptor, boolean visible) {
        void var2_2;
        void var1_1;
        void var3_3;
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.tab).append('@');
        this.appendDescriptor(1, (String)var3_3);
        this.stringBuilder.append('(');
        this.text.add(this.stringBuilder.toString());
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(") : ");
        this.appendTypeReference((int)var1_1);
        this.stringBuilder.append(", ").append(var2_2);
        this.stringBuilder.append(visible ? "\n" : " // invisible\n");
        Textifier textifier = this;
        return textifier.addNewTextifier(textifier.stringBuilder.toString());
    }

    /*
     * WARNING - void declaration
     */
    public void visitAttribute(Attribute attribute) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.tab).append("ATTRIBUTE ");
        this.appendDescriptor(-1, attribute.type);
        if (attribute instanceof TextifierSupport) {
            void var1_1;
            if (this.labelNames == null) {
                this.labelNames = new HashMap<Label, String>();
            }
            ((TextifierSupport)var1_1).textify(this.stringBuilder, this.labelNames);
        } else {
            this.stringBuilder.append(" : unknown\n");
        }
        this.text.add(this.stringBuilder.toString());
    }

    /*
     * WARNING - void declaration
     */
    private void appendAccess(int accessFlags) {
        void var1_1;
        if ((accessFlags & 1) != 0) {
            this.stringBuilder.append("public ");
        }
        if ((accessFlags & 2) != 0) {
            this.stringBuilder.append("private ");
        }
        if ((accessFlags & 4) != 0) {
            this.stringBuilder.append("protected ");
        }
        if ((accessFlags & 0x10) != 0) {
            this.stringBuilder.append("final ");
        }
        if ((accessFlags & 8) != 0) {
            this.stringBuilder.append("static ");
        }
        if ((accessFlags & 0x20) != 0) {
            this.stringBuilder.append("synchronized ");
        }
        if ((accessFlags & 0x40) != 0) {
            this.stringBuilder.append("volatile ");
        }
        if ((accessFlags & 0x80) != 0) {
            this.stringBuilder.append("transient ");
        }
        if ((accessFlags & 0x400) != 0) {
            this.stringBuilder.append("abstract ");
        }
        if ((accessFlags & 0x800) != 0) {
            this.stringBuilder.append("strictfp ");
        }
        if ((accessFlags & 0x1000) != 0) {
            this.stringBuilder.append("synthetic ");
        }
        if ((accessFlags & 0x8000) != 0) {
            this.stringBuilder.append("mandated ");
        }
        if ((var1_1 & 0x4000) != 0) {
            this.stringBuilder.append("enum ");
        }
    }

    /*
     * WARNING - void declaration
     */
    private void appendRawAccess(int accessFlags) {
        void var1_1;
        this.stringBuilder.append("// access flags 0x").append(Integer.toHexString((int)var1_1).toUpperCase()).append('\n');
    }

    /*
     * WARNING - void declaration
     */
    protected void appendDescriptor(int type, String value) {
        void var1_1;
        if (type == 5 || type == 2 || var1_1 == 4) {
            if (value != null) {
                this.stringBuilder.append("// signature ").append(value).append('\n');
                return;
            }
        } else {
            void var2_2;
            this.stringBuilder.append((String)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void appendJavaDeclaration(String name, String signature) {
        void var1_1;
        void var2_2;
        TraceSignatureVisitor traceSignatureVisitor = new TraceSignatureVisitor(this.access);
        new SignatureReader((String)var2_2).accept(traceSignatureVisitor);
        this.stringBuilder.append("// declaration: ");
        if (traceSignatureVisitor.getReturnType() != null) {
            this.stringBuilder.append(traceSignatureVisitor.getReturnType());
            this.stringBuilder.append(' ');
        }
        this.stringBuilder.append((String)var1_1);
        this.stringBuilder.append(traceSignatureVisitor.getDeclaration());
        if (traceSignatureVisitor.getExceptions() != null) {
            void var3_3;
            this.stringBuilder.append(" throws ").append(var3_3.getExceptions());
        }
        this.stringBuilder.append('\n');
    }

    /*
     * WARNING - void declaration
     */
    protected void appendLabel(Label label) {
        void var2_2;
        String name;
        if (this.labelNames == null) {
            this.labelNames = new HashMap<Label, String>();
        }
        if ((name = this.labelNames.get(label)) == null) {
            void var1_1;
            name = "L" + this.labelNames.size();
            this.labelNames.put((Label)var1_1, name);
        }
        this.stringBuilder.append((String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    protected void appendHandle(Handle handle) {
        void var1_1;
        void var3_3;
        void var2_2;
        int tag = handle.getTag();
        this.stringBuilder.append("// handle kind 0x").append(Integer.toHexString(tag)).append(" : ");
        boolean isMethodHandle = false;
        switch (var2_2) {
            case 1: {
                this.stringBuilder.append("GETFIELD");
                break;
            }
            case 2: {
                this.stringBuilder.append("GETSTATIC");
                break;
            }
            case 3: {
                this.stringBuilder.append("PUTFIELD");
                break;
            }
            case 4: {
                this.stringBuilder.append("PUTSTATIC");
                break;
            }
            case 9: {
                this.stringBuilder.append("INVOKEINTERFACE");
                isMethodHandle = true;
                break;
            }
            case 7: {
                this.stringBuilder.append("INVOKESPECIAL");
                isMethodHandle = true;
                break;
            }
            case 6: {
                this.stringBuilder.append("INVOKESTATIC");
                isMethodHandle = true;
                break;
            }
            case 5: {
                this.stringBuilder.append("INVOKEVIRTUAL");
                isMethodHandle = true;
                break;
            }
            case 8: {
                this.stringBuilder.append("NEWINVOKESPECIAL");
                isMethodHandle = true;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.stringBuilder.append('\n');
        this.stringBuilder.append(this.tab3);
        this.appendDescriptor(0, handle.getOwner());
        this.stringBuilder.append('.');
        this.stringBuilder.append(handle.getName());
        if (!isMethodHandle) {
            this.stringBuilder.append('(');
        }
        this.appendDescriptor(9, handle.getDesc());
        if (var3_3 == false) {
            this.stringBuilder.append(')');
        }
        if (var1_1.isInterface()) {
            this.stringBuilder.append(" itf");
        }
    }

    private void maybeAppendComma(int numValues) {
        if (numValues > 0) {
            this.stringBuilder.append(", ");
        }
    }

    /*
     * WARNING - void declaration
     */
    private void appendTypeReference(int typeRef) {
        TypeReference typeReference = new TypeReference(typeRef);
        switch (typeReference.getSort()) {
            case 0: {
                this.stringBuilder.append("CLASS_TYPE_PARAMETER ").append(typeReference.getTypeParameterIndex());
                return;
            }
            case 1: {
                this.stringBuilder.append("METHOD_TYPE_PARAMETER ").append(typeReference.getTypeParameterIndex());
                return;
            }
            case 16: {
                this.stringBuilder.append("CLASS_EXTENDS ").append(typeReference.getSuperTypeIndex());
                return;
            }
            case 17: {
                this.stringBuilder.append("CLASS_TYPE_PARAMETER_BOUND ").append(typeReference.getTypeParameterIndex()).append(", ").append(typeReference.getTypeParameterBoundIndex());
                return;
            }
            case 18: {
                this.stringBuilder.append("METHOD_TYPE_PARAMETER_BOUND ").append(typeReference.getTypeParameterIndex()).append(", ").append(typeReference.getTypeParameterBoundIndex());
                return;
            }
            case 19: {
                this.stringBuilder.append("FIELD");
                return;
            }
            case 20: {
                this.stringBuilder.append("METHOD_RETURN");
                return;
            }
            case 21: {
                this.stringBuilder.append("METHOD_RECEIVER");
                return;
            }
            case 22: {
                this.stringBuilder.append("METHOD_FORMAL_PARAMETER ").append(typeReference.getFormalParameterIndex());
                return;
            }
            case 23: {
                this.stringBuilder.append("THROWS ").append(typeReference.getExceptionIndex());
                return;
            }
            case 64: {
                this.stringBuilder.append("LOCAL_VARIABLE");
                return;
            }
            case 65: {
                this.stringBuilder.append("RESOURCE_VARIABLE");
                return;
            }
            case 66: {
                this.stringBuilder.append("EXCEPTION_PARAMETER ").append(typeReference.getTryCatchBlockIndex());
                return;
            }
            case 67: {
                this.stringBuilder.append("INSTANCEOF");
                return;
            }
            case 68: {
                this.stringBuilder.append("NEW");
                return;
            }
            case 69: {
                this.stringBuilder.append("CONSTRUCTOR_REFERENCE");
                return;
            }
            case 70: {
                this.stringBuilder.append("METHOD_REFERENCE");
                return;
            }
            case 71: {
                this.stringBuilder.append("CAST ").append(typeReference.getTypeArgumentIndex());
                return;
            }
            case 72: {
                this.stringBuilder.append("CONSTRUCTOR_INVOCATION_TYPE_ARGUMENT ").append(typeReference.getTypeArgumentIndex());
                return;
            }
            case 73: {
                this.stringBuilder.append("METHOD_INVOCATION_TYPE_ARGUMENT ").append(typeReference.getTypeArgumentIndex());
                return;
            }
            case 74: {
                this.stringBuilder.append("CONSTRUCTOR_REFERENCE_TYPE_ARGUMENT ").append(typeReference.getTypeArgumentIndex());
                return;
            }
            case 75: {
                void var1_2;
                this.stringBuilder.append("METHOD_REFERENCE_TYPE_ARGUMENT ").append(var1_2.getTypeArgumentIndex());
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    private void appendFrameTypes(int numTypes, Object[] frameTypes) {
        for (int i = 0; i < numTypes; ++i) {
            if (i > 0) {
                this.stringBuilder.append(' ');
            }
            if (frameTypes[i] instanceof String) {
                String descriptor = (String)frameTypes[i];
                if (descriptor.charAt(0) == '[') {
                    this.appendDescriptor(1, descriptor);
                    continue;
                }
                this.appendDescriptor(0, descriptor);
                continue;
            }
            if (frameTypes[i] instanceof Integer) {
                this.stringBuilder.append(FRAME_TYPES.get((Integer)frameTypes[i]));
                continue;
            }
            this.appendLabel((Label)frameTypes[i]);
        }
    }

    /*
     * WARNING - void declaration
     */
    private Textifier addNewTextifier(String endText) {
        void var2_2;
        Textifier textifier = this.createTextifier();
        this.text.add(textifier.getText());
        if (endText != null) {
            void var1_1;
            this.text.add(var1_1);
        }
        return var2_2;
    }

    protected Textifier createTextifier() {
        return new Textifier(this.api);
    }
}

