/*
 * Decompiled with CFR 0.152.
 */
package net.sf.juife.wizard;

import java.util.Vector;
import net.sf.juife.wizard.AbstractWizardModel;
import net.sf.juife.wizard.WizardPage;

public class DefaultWizardModel
extends AbstractWizardModel {
    private final Vector<WizardPage> pages = new Vector();
    private int pos = -1;
    private int last = -1;
    private Vector<String> steps = null;
    private final Vector<String> stepsMap = new Vector();

    public DefaultWizardModel() {
    }

    public DefaultWizardModel(WizardPage[] pages) {
        this.setPages(pages);
    }

    public void addPage(WizardPage page) {
        if (page == null) {
            throw new IllegalArgumentException("page must be non-null");
        }
        this.pages.add(page);
    }

    public void setPages(WizardPage[] pages) {
        this.pages.removeAllElements();
        if (pages == null) {
            return;
        }
        for (WizardPage p : pages) {
            this.addPage(p);
        }
    }

    public void setLast() {
        if (this.pages.size() == 0) {
            throw new IllegalArgumentException("The wizard model is empty");
        }
        this.last = this.pages.size() - 1;
    }

    public void setLast(WizardPage page) {
        this.last = this.pages.indexOf(page);
        if (this.last == -1) {
            throw new IllegalArgumentException("The wizard model does not contain the specified page");
        }
    }

    @Override
    public boolean hasNext() {
        return this.pos + 1 < this.pages.size();
    }

    @Override
    public WizardPage next() {
        WizardPage wp = this.pages.get(++this.pos);
        this.fireActionPerformed();
        return wp;
    }

    @Override
    public boolean hasPrevious() {
        return this.pos > 0;
    }

    @Override
    public WizardPage previous() {
        WizardPage wp = this.pages.get(--this.pos);
        this.fireActionPerformed();
        return wp;
    }

    @Override
    public boolean hasLast() {
        return this.last != -1;
    }

    @Override
    public WizardPage last() {
        this.pos = this.last;
        WizardPage wp = this.pages.get(this.pos);
        this.fireActionPerformed();
        return wp;
    }

    @Override
    public WizardPage getCurrentPage() {
        return this.pos == -1 ? null : this.pages.get(this.pos);
    }

    @Override
    public String[] getSteps() {
        return this.steps == null ? null : this.steps.toArray(new String[this.steps.size()]);
    }

    @Override
    public String getCurrentStep() {
        return this.pos == -1 ? null : this.stepsMap.get(this.pos);
    }

    public void addStep(String step) {
        this.addStep(step, 1);
    }

    public void addStep(String step, int pageCount) {
        if (this.steps == null) {
            this.steps = new Vector();
        }
        this.steps.add(step);
        for (int i = 0; i < pageCount; ++i) {
            this.stepsMap.add(step);
        }
    }
}

