/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals.graph;

import java.util.Arrays;
import java.util.Set;
import org.apache.kafka.streams.kstream.internals.KTableValueGetterSupplier;
import org.apache.kafka.streams.kstream.internals.graph.ProcessorGraphNode;
import org.apache.kafka.streams.kstream.internals.graph.ProcessorParameters;
import org.apache.kafka.streams.processor.internals.InternalTopologyBuilder;

public class ProcessorToStateConnectorNode<K, V>
extends ProcessorGraphNode<K, V> {
    private final String[] storeNames;

    public ProcessorToStateConnectorNode(ProcessorParameters<K, V, ?, ?> processorParameters, Set<KTableValueGetterSupplier<?, ?>> valueGetterSuppliers) {
        super(processorParameters.processorName(), processorParameters);
        this.storeNames = (String[])valueGetterSuppliers.stream().flatMap(s -> Arrays.stream(s.storeNames())).toArray(String[]::new);
    }

    public ProcessorToStateConnectorNode(String nodeName, ProcessorParameters<K, V, ?, ?> processorParameters, String[] storeNames) {
        super(nodeName, processorParameters);
        this.storeNames = storeNames;
    }

    @Override
    public String toString() {
        return "ProcessorNode{storeNames=" + Arrays.toString(this.storeNames) + "} " + super.toString();
    }

    @Override
    public void writeToTopology(InternalTopologyBuilder topologyBuilder) {
        this.processorParameters().addProcessorTo(topologyBuilder, this.parentNodeNames());
        if (this.storeNames != null && this.storeNames.length > 0) {
            topologyBuilder.connectProcessorAndStateStores(this.processorParameters().processorName(), this.storeNames);
        }
    }
}

