/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.lock.internal;

import jakarta.persistence.Timeout;
import java.sql.Connection;
import org.hibernate.HibernateException;
import org.hibernate.Timeouts;
import org.hibernate.dialect.RowLockStrategy;
import org.hibernate.dialect.lock.internal.Helper;
import org.hibernate.dialect.lock.spi.ConnectionLockTimeoutStrategy;
import org.hibernate.dialect.lock.spi.LockTimeoutType;
import org.hibernate.dialect.lock.spi.LockingSupport;
import org.hibernate.dialect.lock.spi.OuterJoinLockingType;
import org.hibernate.engine.spi.SessionFactoryImplementor;

public class CockroachLockingSupport
implements LockingSupport,
LockingSupport.Metadata,
ConnectionLockTimeoutStrategy {
    public static final CockroachLockingSupport COCKROACH_LOCKING_SUPPORT = new CockroachLockingSupport(false);
    public static final CockroachLockingSupport LEGACY_COCKROACH_LOCKING_SUPPORT = new CockroachLockingSupport(true);
    private final boolean supportsNoWait;
    private final RowLockStrategy rowLockStrategy;

    public CockroachLockingSupport(boolean isLegacy) {
        this.rowLockStrategy = isLegacy ? RowLockStrategy.NONE : RowLockStrategy.TABLE;
        this.supportsNoWait = !isLegacy;
    }

    @Override
    public LockingSupport.Metadata getMetadata() {
        return this;
    }

    @Override
    public RowLockStrategy getWriteRowLockStrategy() {
        return this.rowLockStrategy;
    }

    @Override
    public LockTimeoutType getLockTimeoutType(Timeout timeout) {
        return switch (timeout.milliseconds()) {
            case -1 -> LockTimeoutType.QUERY;
            case 0 -> {
                if (this.supportsNoWait) {
                    yield LockTimeoutType.QUERY;
                }
                yield LockTimeoutType.NONE;
            }
            case -2 -> LockTimeoutType.NONE;
            default -> LockTimeoutType.CONNECTION;
        };
    }

    @Override
    public OuterJoinLockingType getOuterJoinLockingType() {
        return OuterJoinLockingType.UNSUPPORTED;
    }

    @Override
    public ConnectionLockTimeoutStrategy getConnectionLockTimeoutStrategy() {
        return this;
    }

    @Override
    public ConnectionLockTimeoutStrategy.Level getSupportedLevel() {
        return ConnectionLockTimeoutStrategy.Level.SUPPORTED;
    }

    @Override
    public Timeout getLockTimeout(Connection connection, SessionFactoryImplementor factory) {
        return Helper.getLockTimeout("show lock_timeout", resultSet -> {
            int millis = resultSet.getInt(1);
            return switch (millis) {
                case 0 -> Timeouts.WAIT_FOREVER;
                default -> Timeout.milliseconds((int)millis);
            };
        }, connection, factory);
    }

    @Override
    public void setLockTimeout(Timeout timeout, Connection connection, SessionFactoryImplementor factory) {
        Helper.setLockTimeout(timeout, t -> {
            int milliseconds = timeout.milliseconds();
            if (milliseconds == -2) {
                throw new HibernateException("Connection lock-timeout does not accept skip-locked");
            }
            if (milliseconds == 0) {
                throw new HibernateException("Connection lock-timeout does not accept no-wait");
            }
            return milliseconds == -1 ? 0 : milliseconds;
        }, "set lock_timeout = %s", connection, factory);
    }
}

