/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.admin.indices.create;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicReference;
import org.opensearch.action.ActionType;
import org.opensearch.action.admin.indices.create.CreateIndexClusterStateUpdateRequest;
import org.opensearch.action.admin.indices.create.CreateIndexRequest;
import org.opensearch.action.admin.indices.create.CreateIndexResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.ActiveShardCount;
import org.opensearch.action.support.ActiveShardsObserver;
import org.opensearch.action.support.TransportIndicesResolvingAction;
import org.opensearch.action.support.clustermanager.TransportClusterManagerNodeAction;
import org.opensearch.cluster.AckedClusterStateUpdateTask;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.ack.AckedRequest;
import org.opensearch.cluster.ack.ClusterStateUpdateResponse;
import org.opensearch.cluster.block.ClusterBlockException;
import org.opensearch.cluster.block.ClusterBlockLevel;
import org.opensearch.cluster.metadata.ComposableIndexTemplate;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.metadata.Metadata;
import org.opensearch.cluster.metadata.MetadataCreateDataStreamService;
import org.opensearch.cluster.metadata.MetadataCreateIndexService;
import org.opensearch.cluster.metadata.MetadataIndexTemplateService;
import org.opensearch.cluster.metadata.ResolvedIndices;
import org.opensearch.cluster.service.ClusterManagerTask;
import org.opensearch.cluster.service.ClusterManagerTaskThrottler;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.Priority;
import org.opensearch.common.inject.Inject;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportService;

public final class AutoCreateAction
extends ActionType<CreateIndexResponse> {
    public static final AutoCreateAction INSTANCE = new AutoCreateAction();
    public static final String NAME = "indices:admin/auto_create";

    private AutoCreateAction() {
        super(NAME, CreateIndexResponse::new);
    }

    static ComposableIndexTemplate.DataStreamTemplate resolveAutoCreateDataStream(CreateIndexRequest request, Metadata metadata) {
        ComposableIndexTemplate composableIndexTemplate;
        String v2Template = MetadataIndexTemplateService.findV2Template(metadata, request.index(), false);
        if (v2Template != null && (composableIndexTemplate = metadata.templatesV2().get(v2Template)).getDataStreamTemplate() != null) {
            return composableIndexTemplate.getDataStreamTemplate();
        }
        return null;
    }

    public static final class TransportAction
    extends TransportClusterManagerNodeAction<CreateIndexRequest, CreateIndexResponse>
    implements TransportIndicesResolvingAction<CreateIndexRequest> {
        private final ActiveShardsObserver activeShardsObserver;
        private final MetadataCreateIndexService createIndexService;
        private final MetadataCreateDataStreamService metadataCreateDataStreamService;
        private final ClusterManagerTaskThrottler.ThrottlingKey autoCreateTaskKey;

        @Inject
        public TransportAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, MetadataCreateIndexService createIndexService, MetadataCreateDataStreamService metadataCreateDataStreamService) {
            super(AutoCreateAction.NAME, transportService, clusterService, threadPool, actionFilters, CreateIndexRequest::new, indexNameExpressionResolver);
            this.activeShardsObserver = new ActiveShardsObserver(clusterService, threadPool);
            this.createIndexService = createIndexService;
            this.metadataCreateDataStreamService = metadataCreateDataStreamService;
            this.autoCreateTaskKey = clusterService.registerClusterManagerTask(ClusterManagerTask.AUTO_CREATE, true);
        }

        @Override
        protected String executor() {
            return "same";
        }

        @Override
        protected CreateIndexResponse read(StreamInput in) throws IOException {
            return new CreateIndexResponse(in);
        }

        @Override
        protected void clusterManagerOperation(final CreateIndexRequest request, ClusterState state, ActionListener<CreateIndexResponse> finalListener) {
            final AtomicReference indexNameRef = new AtomicReference();
            ActionListener listener = ActionListener.wrap(response -> {
                String indexName = (String)indexNameRef.get();
                assert (indexName != null);
                if (response.isAcknowledged()) {
                    this.activeShardsObserver.waitForActiveShards(new String[]{indexName}, ActiveShardCount.DEFAULT, request.timeout(), shardsAcked -> finalListener.onResponse((Object)new CreateIndexResponse(true, (boolean)shardsAcked, indexName)), arg_0 -> ((ActionListener)finalListener).onFailure(arg_0));
                } else {
                    finalListener.onResponse((Object)new CreateIndexResponse(false, false, indexName));
                }
            }, arg_0 -> finalListener.onFailure(arg_0));
            this.clusterService.submitStateUpdateTask("auto create [" + request.index() + "]", new AckedClusterStateUpdateTask<ClusterStateUpdateResponse>(Priority.URGENT, (AckedRequest)request, listener){

                @Override
                protected ClusterStateUpdateResponse newResponse(boolean acknowledged) {
                    return new ClusterStateUpdateResponse(acknowledged);
                }

                @Override
                public ClusterManagerTaskThrottler.ThrottlingKey getClusterManagerThrottlingKey() {
                    return autoCreateTaskKey;
                }

                @Override
                public ClusterState execute(ClusterState currentState) throws Exception {
                    ComposableIndexTemplate.DataStreamTemplate dataStreamTemplate = AutoCreateAction.resolveAutoCreateDataStream(request, currentState.metadata());
                    if (dataStreamTemplate != null) {
                        MetadataCreateDataStreamService.CreateDataStreamClusterStateUpdateRequest createRequest = new MetadataCreateDataStreamService.CreateDataStreamClusterStateUpdateRequest(request.index(), request.clusterManagerNodeTimeout(), request.timeout());
                        ClusterState clusterState = metadataCreateDataStreamService.createDataStream(createRequest, currentState);
                        indexNameRef.set(clusterState.metadata().dataStreams().get(request.index()).getIndices().get(0).getName());
                        return clusterState;
                    }
                    String indexName = indexNameExpressionResolver.resolveDateMathExpression(request.index());
                    indexNameRef.set(indexName);
                    CreateIndexClusterStateUpdateRequest updateRequest = (CreateIndexClusterStateUpdateRequest)((CreateIndexClusterStateUpdateRequest)new CreateIndexClusterStateUpdateRequest(request.cause(), indexName, request.index()).ackTimeout(request.timeout())).clusterManagerNodeTimeout(request.clusterManagerNodeTimeout());
                    return createIndexService.applyCreateIndexRequest(currentState, updateRequest, false);
                }
            });
        }

        @Override
        protected ClusterBlockException checkBlock(CreateIndexRequest request, ClusterState state) {
            return state.blocks().indexBlockedException(ClusterBlockLevel.METADATA_WRITE, request.index());
        }

        public ResolvedIndices resolveIndices(CreateIndexRequest request) {
            ClusterState clusterState = this.clusterService.state();
            ComposableIndexTemplate.DataStreamTemplate dataStreamTemplate = AutoCreateAction.resolveAutoCreateDataStream(request, clusterState.metadata());
            if (dataStreamTemplate != null) {
                return ResolvedIndices.of(request.index());
            }
            return ResolvedIndices.of(this.indexNameExpressionResolver.resolveDateMathExpression(request.index()));
        }
    }
}

