/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

export { OuiHeader } from './header';
export { OuiHeaderAlert } from './header_alert';
export { OuiHeaderBreadcrumbs } from './header_breadcrumbs';
export { OuiHeaderLink, OuiHeaderLinks } from './header_links';
export { OuiHeaderLogo } from './header_logo';
export { OuiHeaderSection, OuiHeaderSectionItem, OuiHeaderSectionItemButton } from './header_section';

/* OUI -> EUI Aliases: Build-Time */
export { EuiHeader } from '../../eui_components/header/header';
/* OUI -> EUI Aliases: Build-Time */
export { EuiHeaderAlert } from '../../eui_components/header/header_alert';
/* OUI -> EUI Aliases: Build-Time */
export { EuiHeaderBreadcrumbs } from '../../eui_components/header/header_breadcrumbs';
/* OUI -> EUI Aliases: Build-Time */
export { EuiHeaderLink, EuiHeaderLinks } from '../../eui_components/header/header_links';
/* OUI -> EUI Aliases: Build-Time */
export { EuiHeaderLogo } from '../../eui_components/header/header_logo';
/* OUI -> EUI Aliases: Build-Time */
export { EuiHeaderSection, EuiHeaderSectionItem, EuiHeaderSectionItemButton } from '../../eui_components/header/header_section';