/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring.classes.ui;

import com.google.common.base.Preconditions;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.refactoring.classMembers.MemberInfoChangeListener;
import com.intellij.refactoring.classMembers.MemberInfoModel;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.border.IdeaTitledBorder;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.refactoring.classes.membersManager.PyMemberInfo;
import com.jetbrains.python.refactoring.classes.ui.PyMemberSelectionTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import org.jetbrains.annotations.NotNull;

public class PyMemberSelectionPanel
extends JPanel {
    private static final List<PyMemberInfo<PyElement>> EMPTY_MEMBER_INFO = Collections.emptyList();
    private final PyMemberSelectionTable myTable;
    private boolean myInitialized;

    public PyMemberSelectionPanel(@NlsContexts.BorderTitle @NotNull String title, boolean supportAbstract) {
        if (title == null) {
            PyMemberSelectionPanel.$$$reportNull$$$0(0);
        }
        this(title, EMPTY_MEMBER_INFO, null, supportAbstract);
    }

    public PyMemberSelectionPanel(@NlsContexts.BorderTitle String title, List<PyMemberInfo<PyElement>> memberInfo, MemberInfoModel<PyElement, PyMemberInfo<PyElement>> model2, boolean supportAbstract) {
        IdeaTitledBorder titledBorder = IdeBorderFactory.createTitledBorder((String)title, (boolean)false);
        Border emptyBorder = BorderFactory.createEmptyBorder(0, 5, 5, 5);
        CompoundBorder border = BorderFactory.createCompoundBorder((Border)titledBorder, emptyBorder);
        this.setBorder(border);
        this.setLayout(new BorderLayout());
        this.myTable = new PyMemberSelectionTable(memberInfo, model2, supportAbstract);
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)((Object)this.myTable));
        this.add((Component)scrollPane, "Center");
    }

    public void init(@NotNull MemberInfoModel<PyElement, PyMemberInfo<PyElement>> memberInfoModel, @NotNull Collection<PyMemberInfo<PyElement>> members) {
        if (memberInfoModel == null) {
            PyMemberSelectionPanel.$$$reportNull$$$0(1);
        }
        if (members == null) {
            PyMemberSelectionPanel.$$$reportNull$$$0(2);
        }
        Preconditions.checkState((!this.myInitialized ? 1 : 0) != 0, (Object)"Already myInitialized");
        this.myTable.setMemberInfos(members);
        this.myTable.setMemberInfoModel(memberInfoModel);
        this.myTable.addMemberInfoChangeListener((MemberInfoChangeListener)memberInfoModel);
        this.myInitialized = true;
    }

    @NotNull
    public Collection<PyMemberInfo<PyElement>> getSelectedMemberInfos() {
        Preconditions.checkState((boolean)this.myInitialized, (Object)"Call #init first");
        Collection collection = this.myTable.getSelectedMemberInfos();
        if (collection == null) {
            PyMemberSelectionPanel.$$$reportNull$$$0(3);
        }
        return collection;
    }

    public void redraw() {
        this.myTable.redraw();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memberInfoModel";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "members";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/refactoring/classes/ui/PyMemberSelectionPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/refactoring/classes/ui/PyMemberSelectionPanel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedMemberInfos";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "init";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

