/*
 * Decompiled with CFR 0.152.
 */
package org.apache.el;

import jakarta.el.ELContext;
import jakarta.el.ELException;
import jakarta.el.FunctionMapper;
import jakarta.el.MethodExpression;
import jakarta.el.MethodInfo;
import jakarta.el.MethodNotFoundException;
import jakarta.el.MethodReference;
import jakarta.el.PropertyNotFoundException;
import jakarta.el.VariableMapper;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.el.lang.EvaluationContext;
import org.apache.el.lang.ExpressionBuilder;
import org.apache.el.parser.Node;
import org.apache.el.util.ReflectionUtil;

public final class MethodExpressionImpl
extends MethodExpression
implements Externalizable {
    private Class<?> expectedType;
    private String expr;
    private FunctionMapper fnMapper;
    private VariableMapper varMapper;
    private transient Node node;
    private Class<?>[] paramTypes;

    public MethodExpressionImpl() {
    }

    public MethodExpressionImpl(String string, Node node, FunctionMapper functionMapper, VariableMapper variableMapper, Class<?> clazz, Class<?>[] classArray) {
        this.expr = string;
        this.node = node;
        this.fnMapper = functionMapper;
        this.varMapper = variableMapper;
        this.expectedType = clazz;
        this.paramTypes = classArray;
    }

    public boolean equals(Object object) {
        return object instanceof MethodExpressionImpl && object.hashCode() == this.hashCode();
    }

    public String getExpressionString() {
        return this.expr;
    }

    public MethodInfo getMethodInfo(ELContext eLContext) throws PropertyNotFoundException, MethodNotFoundException, ELException {
        Node node = this.getNode();
        EvaluationContext evaluationContext = new EvaluationContext(eLContext, this.fnMapper, this.varMapper);
        evaluationContext.notifyBeforeEvaluation(this.getExpressionString());
        MethodInfo methodInfo = node.getMethodInfo(evaluationContext, this.paramTypes);
        evaluationContext.notifyAfterEvaluation(this.getExpressionString());
        return methodInfo;
    }

    private Node getNode() throws ELException {
        if (this.node == null) {
            this.node = ExpressionBuilder.createNode(this.expr);
        }
        return this.node;
    }

    public int hashCode() {
        return this.expr.hashCode();
    }

    public Object invoke(ELContext eLContext, Object[] objectArray) throws PropertyNotFoundException, MethodNotFoundException, ELException {
        EvaluationContext evaluationContext = new EvaluationContext(eLContext, this.fnMapper, this.varMapper);
        evaluationContext.notifyBeforeEvaluation(this.getExpressionString());
        Object object = this.getNode().invoke(evaluationContext, this.paramTypes, objectArray);
        evaluationContext.notifyAfterEvaluation(this.getExpressionString());
        return object;
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.expr = objectInput.readUTF();
        String string = objectInput.readUTF();
        if (!string.isEmpty()) {
            this.expectedType = ReflectionUtil.forName(string);
        }
        this.paramTypes = ReflectionUtil.toTypeArray((String[])objectInput.readObject());
        this.fnMapper = (FunctionMapper)objectInput.readObject();
        this.varMapper = (VariableMapper)objectInput.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeUTF(this.expr);
        objectOutput.writeUTF(this.expectedType != null ? this.expectedType.getName() : "");
        objectOutput.writeObject(ReflectionUtil.toTypeNameArray(this.paramTypes));
        objectOutput.writeObject(this.fnMapper);
        objectOutput.writeObject(this.varMapper);
    }

    public boolean isLiteralText() {
        return false;
    }

    public boolean isParametersProvided() {
        return this.getNode().isParametersProvided();
    }

    public MethodReference getMethodReference(ELContext eLContext) {
        EvaluationContext evaluationContext = new EvaluationContext(eLContext, this.fnMapper, this.varMapper);
        evaluationContext.notifyBeforeEvaluation(this.getExpressionString());
        MethodReference methodReference = this.getNode().getMethodReference(evaluationContext);
        evaluationContext.notifyAfterEvaluation(this.getExpressionString());
        return methodReference;
    }
}

